package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmPropertyLivenessTestHttpHeader private(
  name: Option[String],
  value: Option[String]
) derives Decoder

object GtmPropertyLivenessTestHttpHeader:
  given outputOps: {} with
    extension(output: Output[GtmPropertyLivenessTestHttpHeader])
      def name: Output[Option[String]] = output.map(_.name)
      def value: Output[Option[String]] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmPropertyLivenessTestHttpHeader]])
      def name: Output[Option[String]] = output.map(_.flatMap(_.name))
      def value: Output[Option[String]] = output.map(_.flatMap(_.value))


