package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmPropertyTrafficTarget private(
  datacenterId: Option[Int],
  enabled: Option[Boolean],
  handoutCname: Option[String],
  name: Option[String],
  servers: Option[scala.collection.immutable.List[String]],
  weight: Option[Double]
) derives Decoder

object GtmPropertyTrafficTarget:
  given outputOps: {} with
    extension(output: Output[GtmPropertyTrafficTarget])
      def datacenterId: Output[Option[Int]] = output.map(_.datacenterId)
      def enabled: Output[Option[Boolean]] = output.map(_.enabled)
      def handoutCname: Output[Option[String]] = output.map(_.handoutCname)
      def name: Output[Option[String]] = output.map(_.name)
      def servers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.servers)
      def weight: Output[Option[Double]] = output.map(_.weight)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmPropertyTrafficTarget]])
      def datacenterId: Output[Option[Int]] = output.map(_.flatMap(_.datacenterId))
      def enabled: Output[Option[Boolean]] = output.map(_.flatMap(_.enabled))
      def handoutCname: Output[Option[String]] = output.map(_.flatMap(_.handoutCname))
      def name: Output[Option[String]] = output.map(_.flatMap(_.name))
      def servers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.servers))
      def weight: Output[Option[Double]] = output.map(_.flatMap(_.weight))


