package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmResourceResourceInstance private(
  datacenterId: Int,
  loadObject: Option[String],
  loadObjectPort: Option[Int],
  loadServers: Option[scala.collection.immutable.List[String]],
  useDefaultLoadObject: Option[Boolean]
) derives Decoder

object GtmResourceResourceInstance:
  given outputOps: {} with
    extension(output: Output[GtmResourceResourceInstance])
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def loadObject: Output[Option[String]] = output.map(_.loadObject)
      def loadObjectPort: Output[Option[Int]] = output.map(_.loadObjectPort)
      def loadServers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.loadServers)
      def useDefaultLoadObject: Output[Option[Boolean]] = output.map(_.useDefaultLoadObject)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmResourceResourceInstance]])
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def loadObject: Output[Option[String]] = output.map(_.flatMap(_.loadObject))
      def loadObjectPort: Output[Option[Int]] = output.map(_.flatMap(_.loadObjectPort))
      def loadServers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.loadServers))
      def useDefaultLoadObject: Output[Option[Boolean]] = output.map(_.flatMap(_.useDefaultLoadObject))


