package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyActivationComplianceRecord private(
  noncomplianceReasonEmergency: Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonEmergency],
  noncomplianceReasonNoProductionTraffic: Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNoProductionTraffic],
  noncomplianceReasonNone: Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNone],
  noncomplianceReasonOther: Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonOther]
) derives Decoder

object PropertyActivationComplianceRecord:
  given outputOps: {} with
    extension(output: Output[PropertyActivationComplianceRecord])
      def noncomplianceReasonEmergency: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonEmergency]] = output.map(_.noncomplianceReasonEmergency)
      def noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNoProductionTraffic]] = output.map(_.noncomplianceReasonNoProductionTraffic)
      def noncomplianceReasonNone: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNone]] = output.map(_.noncomplianceReasonNone)
      def noncomplianceReasonOther: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonOther]] = output.map(_.noncomplianceReasonOther)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyActivationComplianceRecord]])
      def noncomplianceReasonEmergency: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonEmergency]] = output.map(_.flatMap(_.noncomplianceReasonEmergency))
      def noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNoProductionTraffic]] = output.map(_.flatMap(_.noncomplianceReasonNoProductionTraffic))
      def noncomplianceReasonNone: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonNone]] = output.map(_.flatMap(_.noncomplianceReasonNone))
      def noncomplianceReasonOther: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecordNoncomplianceReasonOther]] = output.map(_.flatMap(_.noncomplianceReasonOther))


