package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyActivationComplianceRecordNoncomplianceReasonNone private(
  customerEmail: Option[String],
  peerReviewedBy: Option[String],
  ticketId: Option[String],
  unitTested: Option[Boolean]
) derives Decoder

object PropertyActivationComplianceRecordNoncomplianceReasonNone:
  given outputOps: {} with
    extension(output: Output[PropertyActivationComplianceRecordNoncomplianceReasonNone])
      def customerEmail: Output[Option[String]] = output.map(_.customerEmail)
      def peerReviewedBy: Output[Option[String]] = output.map(_.peerReviewedBy)
      def ticketId: Output[Option[String]] = output.map(_.ticketId)
      def unitTested: Output[Option[Boolean]] = output.map(_.unitTested)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyActivationComplianceRecordNoncomplianceReasonNone]])
      def customerEmail: Output[Option[String]] = output.map(_.flatMap(_.customerEmail))
      def peerReviewedBy: Output[Option[String]] = output.map(_.flatMap(_.peerReviewedBy))
      def ticketId: Output[Option[String]] = output.map(_.flatMap(_.ticketId))
      def unitTested: Output[Option[Boolean]] = output.map(_.flatMap(_.unitTested))


