package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyActivationRuleError private(
  behaviorName: Option[String],
  detail: Option[String],
  errorLocation: Option[String],
  instance: Option[String],
  statusCode: Option[Int],
  title: Option[String],
  `type`: Option[String]
) derives Decoder

object PropertyActivationRuleError:
  given outputOps: {} with
    extension(output: Output[PropertyActivationRuleError])
      def behaviorName: Output[Option[String]] = output.map(_.behaviorName)
      def detail: Output[Option[String]] = output.map(_.detail)
      def errorLocation: Output[Option[String]] = output.map(_.errorLocation)
      def instance: Output[Option[String]] = output.map(_.instance)
      def statusCode: Output[Option[Int]] = output.map(_.statusCode)
      def title: Output[Option[String]] = output.map(_.title)
      def `type`: Output[Option[String]] = output.map(_.`type`)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyActivationRuleError]])
      def behaviorName: Output[Option[String]] = output.map(_.flatMap(_.behaviorName))
      def detail: Output[Option[String]] = output.map(_.flatMap(_.detail))
      def errorLocation: Output[Option[String]] = output.map(_.flatMap(_.errorLocation))
      def instance: Output[Option[String]] = output.map(_.flatMap(_.instance))
      def statusCode: Output[Option[Int]] = output.map(_.flatMap(_.statusCode))
      def title: Output[Option[String]] = output.map(_.flatMap(_.title))
      def `type`: Output[Option[String]] = output.map(_.flatMap(_.`type`))


