package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyHostname private(
  certProvisioningType: String,
  certStatuses: Option[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyHostnameCertStatus]],
  cnameFrom: String,
  cnameTo: String,
  cnameType: Option[String],
  edgeHostnameId: Option[String]
) derives Decoder

object PropertyHostname:
  given outputOps: {} with
    extension(output: Output[PropertyHostname])
      def certProvisioningType: Output[String] = output.map(_.certProvisioningType)
      def certStatuses: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyHostnameCertStatus]]] = output.map(_.certStatuses)
      def cnameFrom: Output[String] = output.map(_.cnameFrom)
      def cnameTo: Output[String] = output.map(_.cnameTo)
      def cnameType: Output[Option[String]] = output.map(_.cnameType)
      def edgeHostnameId: Output[Option[String]] = output.map(_.edgeHostnameId)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyHostname]])
      def certProvisioningType: Output[Option[String]] = output.map(_.map(_.certProvisioningType))
      def certStatuses: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyHostnameCertStatus]]] = output.map(_.flatMap(_.certStatuses))
      def cnameFrom: Output[Option[String]] = output.map(_.map(_.cnameFrom))
      def cnameTo: Output[Option[String]] = output.map(_.map(_.cnameTo))
      def cnameType: Output[Option[String]] = output.map(_.flatMap(_.cnameType))
      def edgeHostnameId: Output[Option[String]] = output.map(_.flatMap(_.edgeHostnameId))


