package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyHostnameCertStatus private(
  hostname: Option[String],
  productionStatus: Option[String],
  stagingStatus: Option[String],
  target: Option[String]
) derives Decoder

object PropertyHostnameCertStatus:
  given outputOps: {} with
    extension(output: Output[PropertyHostnameCertStatus])
      def hostname: Output[Option[String]] = output.map(_.hostname)
      def productionStatus: Output[Option[String]] = output.map(_.productionStatus)
      def stagingStatus: Output[Option[String]] = output.map(_.stagingStatus)
      def target: Output[Option[String]] = output.map(_.target)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyHostnameCertStatus]])
      def hostname: Output[Option[String]] = output.map(_.flatMap(_.hostname))
      def productionStatus: Output[Option[String]] = output.map(_.flatMap(_.productionStatus))
      def stagingStatus: Output[Option[String]] = output.map(_.flatMap(_.stagingStatus))
      def target: Output[Option[String]] = output.map(_.flatMap(_.target))


