package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class PropertyIncludeActivationComplianceRecord private(
  noncomplianceReasonEmergency: Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonEmergency],
  noncomplianceReasonNoProductionTraffic: Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoProductionTraffic],
  noncomplianceReasonNone: Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNone],
  noncomplianceReasonOther: Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonOther]
) derives Decoder

object PropertyIncludeActivationComplianceRecord:
  given outputOps: {} with
    extension(output: Output[PropertyIncludeActivationComplianceRecord])
      def noncomplianceReasonEmergency: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonEmergency]] = output.map(_.noncomplianceReasonEmergency)
      def noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoProductionTraffic]] = output.map(_.noncomplianceReasonNoProductionTraffic)
      def noncomplianceReasonNone: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNone]] = output.map(_.noncomplianceReasonNone)
      def noncomplianceReasonOther: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonOther]] = output.map(_.noncomplianceReasonOther)

  given optionOutputOps: {} with
    extension(output: Output[Option[PropertyIncludeActivationComplianceRecord]])
      def noncomplianceReasonEmergency: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonEmergency]] = output.map(_.flatMap(_.noncomplianceReasonEmergency))
      def noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoProductionTraffic]] = output.map(_.flatMap(_.noncomplianceReasonNoProductionTraffic))
      def noncomplianceReasonNone: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNone]] = output.map(_.flatMap(_.noncomplianceReasonNone))
      def noncomplianceReasonOther: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonOther]] = output.map(_.flatMap(_.noncomplianceReasonOther))


