package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ProviderConfig private(
  accessToken: String,
  accountKey: Option[String],
  clientSecret: String,
  clientToken: String,
  host: String,
  maxBody: Option[Int]
) derives Decoder

object ProviderConfig:
  given outputOps: {} with
    extension(output: Output[ProviderConfig])
      def accessToken: Output[String] = output.map(_.accessToken)
      def accountKey: Output[Option[String]] = output.map(_.accountKey)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def clientToken: Output[String] = output.map(_.clientToken)
      def host: Output[String] = output.map(_.host)
      def maxBody: Output[Option[Int]] = output.map(_.maxBody)

  given optionOutputOps: {} with
    extension(output: Output[Option[ProviderConfig]])
      def accessToken: Output[Option[String]] = output.map(_.map(_.accessToken))
      def accountKey: Output[Option[String]] = output.map(_.flatMap(_.accountKey))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def clientToken: Output[Option[String]] = output.map(_.map(_.clientToken))
      def host: Output[Option[String]] = output.map(_.map(_.host))
      def maxBody: Output[Option[Int]] = output.map(_.flatMap(_.maxBody))


