/*
 * Decompiled with CFR 0.152.
 */
package besom.json;

import besom.json.JsArray;
import besom.json.JsArray$;
import besom.json.JsFalse$;
import besom.json.JsNull$;
import besom.json.JsNumber;
import besom.json.JsNumber$;
import besom.json.JsObject;
import besom.json.JsObject$;
import besom.json.JsString$;
import besom.json.JsTrue$;
import besom.json.JsValue;
import besom.json.JsonParser$;
import besom.json.JsonParser$ParsingException$;
import besom.json.JsonParserSettings;
import besom.json.JsonParserSettings$;
import besom.json.ParserInput;
import besom.json.ParserInput$Line$;
import java.io.Serializable;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JsonParser {
    private final ParserInput input;
    private final JsonParserSettings settings;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public static JsValue apply(ParserInput parserInput, JsonParserSettings jsonParserSettings) {
        return JsonParser$.MODULE$.apply(parserInput, jsonParserSettings);
    }

    public static JsonParserSettings $lessinit$greater$default$2() {
        return JsonParser$.MODULE$.$lessinit$greater$default$2();
    }

    public JsonParser(ParserInput input, JsonParserSettings settings) {
        this.input = input;
        this.settings = settings;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
        int EOI = 65535;
    }

    public JsonParser(ParserInput input) {
        this(input, JsonParserSettings$.MODULE$.default());
    }

    public JsValue parseJsValue() {
        return this.parseJsValue(false);
    }

    public JsValue parseJsValue(boolean allowTrailingInput) {
        this.ws();
        this.value(this.settings.maxDepth());
        if (!allowTrailingInput) {
            this.require('\uffff');
        }
        return this.jsValue;
    }

    private void value(int remainingNesting) {
        if (remainingNesting == 0) {
            throw new ParsingException("JSON input nested too deeply", "JSON input was nested more deeply than the configured limit of maxNesting = " + this.settings.maxDepth());
        }
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(mark, this.false(), JsFalse$.MODULE$);
                return;
            }
            case 'n': {
                this.simpleValue$1(mark, this.null(), JsNull$.MODULE$);
                return;
            }
            case 't': {
                this.simpleValue$1(mark, this.true(), JsTrue$.MODULE$);
                return;
            }
            case '{': {
                this.advance();
                this.object(remainingNesting);
                return;
            }
            case '[': {
                this.advance();
                this.array(remainingNesting);
                return;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                return;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : JsString$.MODULE$.apply(this.sb.toString());
                return;
            }
        }
        throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private void object(int remainingNesting) {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = this.members$1(remainingNesting, (Map)TreeMap$.MODULE$.empty((Ordering)Ordering.String$.MODULE$));
            this.require('}');
            jsObject = JsObject$.MODULE$.apply((Map<String, JsValue>)map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.empty();
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array(int remainingNesting) {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            ReusableBuilder list = scala.package$.MODULE$.Vector().newBuilder();
            this.values$1(remainingNesting, list);
            this.require(']');
            jsArray = JsArray$.MODULE$.apply((Vector<JsValue>)((Vector)list.result()));
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.empty();
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        JsNumber jsNumber;
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        this.frac();
        this.exp();
        int numberLength = this.input.cursor() - start;
        if (startChar == '0' && this.input.cursor() - start == 1) {
            jsNumber = JsNumber$.MODULE$.zero();
        } else if (numberLength <= this.settings.maxNumberCharacters()) {
            jsNumber = JsNumber$.MODULE$.apply(this.input.sliceCharArray(start, this.input.cursor()));
        } else {
            String numberSnippet = new String(this.input.sliceCharArray(start, package$.MODULE$.min(this.input.cursor(), start + 20)));
            throw new ParsingException("Number too long", "The number starting with '" + numberSnippet + "' had " + (numberLength + " characters which is more than the allowed limit maxNumberCharacters = " + this.settings.maxNumberCharacters() + ". If this is legit input ") + "consider increasing the limit.");
        }
        this.jsValue = jsNumber;
        this.ws();
    }

    private void int() {
        if (!this.ch('0')) {
            this.oneOrMoreDigits();
            return;
        }
    }

    private void frac() {
        if (this.ch('.')) {
            this.oneOrMoreDigits();
            return;
        }
    }

    private void exp() {
        if (this.ch('e') || this.ch('E')) {
            boolean bl = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
            return;
        }
    }

    private void oneOrMoreDigits() {
        if (this.DIGIT()) {
            this.zeroOrMoreDigits();
            return;
        }
        throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        if ((1L << Char$.MODULE$.char2int(this.cursorChar) & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            return this.appendSB(this.cursorChar);
        }
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '\uffff': {
                return false;
            }
            case '\\': {
                this.advance();
                return this.escaped();
            }
        }
        char c2 = c;
        return c2 >= ' ' && this.appendSB(c2);
    }

    private boolean escaped() {
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                return this.appendSB(this.cursorChar);
            }
            case 'b': {
                return this.appendSB('\b');
            }
            case 'f': {
                return this.appendSB('\f');
            }
            case 'n': {
                return this.appendSB('\n');
            }
            case 'r': {
                return this.appendSB('\r');
            }
            case 't': {
                return this.appendSB('\t');
            }
            case 'u': {
                this.advance();
                return this.unicode$1();
            }
        }
        throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
    }

    private void ws() {
        while ((1L << Char$.MODULE$.char2int(this.cursorChar) & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        if (this.cursorChar == c) {
            this.advance();
            return true;
        }
        return false;
    }

    private boolean ws(char c) {
        if (this.ch(c)) {
            this.ws();
            return true;
        }
        return false;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail("'" + c + "'", this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        Object object;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError((Object)line);
        }
        ParserInput.Line line2 = ParserInput$Line$.MODULE$.unapply(line);
        int n = line2._1();
        int n2 = line2._2();
        String string = line2._3();
        int lineNr = n;
        int col = n2;
        String text = string;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
        int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int col2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
        String text2 = (String)tuple3._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : BoxesRunTime.boxToCharacter((char)errorChar).toString();
            object = "character '" + c2 + "'";
        } else {
            object = "end-of-input";
        }
        String unexpected = object;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = "Unexpected " + unexpected + " at input index " + cursor + " (line " + lineNr2 + ", position " + col2 + "), expected " + expected;
        String sanitizedText = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(text2), (Function1 & Serializable)c -> JsonParser.$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
        String detail = "\n" + sanitizedText + "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), col2 - 1) + "^\n";
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(int mark$1, boolean matched, JsValue value) {
        if (matched) {
            this.jsValue = value;
            return;
        }
        throw this.fail("JSON Value", mark$1, this.fail$default$3());
    }

    private final Map members$1(int remainingNesting$1, Map map) {
        Map nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value(remainingNesting$1 - 1);
            nextMap = (Map)map.updated((Object)key, (Object)this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(int remainingNesting$2, ReusableBuilder list$1) {
        do {
            this.value(remainingNesting$2 - 1);
            list$1.$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private final int hexValue$1(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 87;
        }
        if ('A' <= c && c <= 'F') {
            return c - 55;
        }
        throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    private static final /* synthetic */ char $anonfun$1(char c) {
        if (Character.isISOControl(c)) {
            return '?';
        }
        return c;
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public static String $lessinit$greater$default$2() {
            return JsonParser$ParsingException$.MODULE$.$lessinit$greater$default$2();
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super((String)(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : summary + ":" + detail)));
        }

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }
    }
}

