/*
 * Decompiled with CFR 0.152.
 */
package besom.json;

import besom.json.JsFalse$;
import besom.json.JsNull$;
import besom.json.JsNumber;
import besom.json.JsNumber$;
import besom.json.JsString;
import besom.json.JsString$;
import besom.json.JsTrue$;
import besom.json.JsValue;
import besom.json.JsonPrinter$;
import java.io.Serializable;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.math.BigDecimal;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public interface JsonPrinter
extends Function1<JsValue, String> {
    public static boolean requiresEncoding(char c) {
        return JsonPrinter$.MODULE$.requiresEncoding(c);
    }

    public static String apply$(JsonPrinter $this, JsValue x) {
        return $this.apply(x);
    }

    default public String apply(JsValue x) {
        return this.apply(x, (Option<String>)None$.MODULE$, this.apply$default$3());
    }

    public static String apply$(JsonPrinter $this, JsValue x, Option jsonpCallback, StringBuilder sb) {
        return $this.apply(x, (Option<String>)jsonpCallback, sb);
    }

    default public String apply(JsValue x, Option<String> jsonpCallback, StringBuilder sb) {
        Object object;
        Option<String> option = jsonpCallback;
        if (option instanceof Some) {
            String callback = (String)((Some)option).value();
            sb.append(callback).append('(');
            this.print(x, sb);
            object = sb.append(')');
        } else if (None$.MODULE$.equals(option)) {
            this.print(x, sb);
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return sb.toString();
    }

    public static Option apply$default$2$(JsonPrinter $this) {
        return $this.apply$default$2();
    }

    default public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public static StringBuilder apply$default$3$(JsonPrinter $this) {
        return $this.apply$default$3();
    }

    default public StringBuilder apply$default$3() {
        return new StringBuilder(256);
    }

    public void print(JsValue var1, StringBuilder var2);

    public static void printLeaf$(JsonPrinter $this, JsValue x, StringBuilder sb) {
        $this.printLeaf(x, sb);
    }

    default public void printLeaf(JsValue x, StringBuilder sb) {
        JsValue jsValue = x;
        if (JsNull$.MODULE$.equals(jsValue)) {
            sb.append("null");
            return;
        }
        if (JsTrue$.MODULE$.equals(jsValue)) {
            sb.append("true");
            return;
        }
        if (JsFalse$.MODULE$.equals(jsValue)) {
            sb.append("false");
            return;
        }
        if (jsValue instanceof JsNumber) {
            BigDecimal bigDecimal;
            JsNumber jsNumber = JsNumber$.MODULE$.unapply((JsNumber)jsValue);
            BigDecimal x2 = bigDecimal = jsNumber._1();
            sb.append(x2);
            return;
        }
        if (jsValue instanceof JsString) {
            String string;
            JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
            String x3 = string = jsString._1();
            this.printString(x3, sb);
            return;
        }
        throw new IllegalStateException();
    }

    public static void printString$(JsonPrinter $this, String s, StringBuilder sb) {
        $this.printString(s, sb);
    }

    default public void printString(String s, StringBuilder sb) {
        StringBuilder stringBuilder;
        sb.append('\"');
        int n = JsonPrinter.firstToBeEncoded$1(s, JsonPrinter.firstToBeEncoded$default$1$1());
        if (-1 == n) {
            stringBuilder = sb.append(s);
        } else {
            int first = n;
            sb.append(s, 0, first);
            JsonPrinter.append$1(s, sb, first);
            stringBuilder = BoxedUnit.UNIT;
        }
        sb.append('\"');
    }

    public static void printSeq$(JsonPrinter $this, Iterable iterable, Function0 printSeparator, Function1 f) {
        $this.printSeq(iterable, (Function0<BoxedUnit>)printSeparator, f);
    }

    default public <A> void printSeq(Iterable<A> iterable, Function0<BoxedUnit> printSeparator, Function1<A, BoxedUnit> f) {
        BooleanRef first = BooleanRef.create((boolean)true);
        iterable.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (first$1.elem) {
                boolean bl;
                first$1.elem = bl = false;
            } else {
                printSeparator.apply$mcV$sp();
            }
            f.apply(a);
        });
    }

    private static int firstToBeEncoded$1(String s$1, int ix) {
        while (ix != s$1.length()) {
            if (JsonPrinter$.MODULE$.requiresEncoding(s$1.charAt(ix))) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    private static int firstToBeEncoded$default$1$1() {
        return 0;
    }

    private static void append$1(String s$2, StringBuilder sb$1, int ix) {
        while (ix < s$2.length()) {
            StringBuilder stringBuilder;
            char c = s$2.charAt(ix);
            char c2 = c;
            if (!JsonPrinter$.MODULE$.requiresEncoding(c2)) {
                stringBuilder = sb$1.append(c2);
            } else {
                switch (c) {
                    case '\"': {
                        stringBuilder = sb$1.append("\\\"");
                        break;
                    }
                    case '\\': {
                        stringBuilder = sb$1.append("\\\\");
                        break;
                    }
                    case '\b': {
                        stringBuilder = sb$1.append("\\b");
                        break;
                    }
                    case '\f': {
                        stringBuilder = sb$1.append("\\f");
                        break;
                    }
                    case '\n': {
                        stringBuilder = sb$1.append("\\n");
                        break;
                    }
                    case '\r': {
                        stringBuilder = sb$1.append("\\r");
                        break;
                    }
                    case '\t': {
                        stringBuilder = sb$1.append("\\t");
                        break;
                    }
                    default: {
                        char x = c;
                        if (x <= '\u000f') {
                            stringBuilder = sb$1.append("\\u000").append(Integer.toHexString(Char$.MODULE$.char2int(x)));
                            break;
                        }
                        char x2 = c;
                        if (x2 <= '\u00ff') {
                            stringBuilder = sb$1.append("\\u00").append(Integer.toHexString(Char$.MODULE$.char2int(x2)));
                            break;
                        }
                        char x3 = c;
                        if (x3 <= '\u0fff') {
                            stringBuilder = sb$1.append("\\u0").append(Integer.toHexString(Char$.MODULE$.char2int(x3)));
                            break;
                        }
                        char x4 = c;
                        stringBuilder = sb$1.append("\\u").append(Integer.toHexString(Char$.MODULE$.char2int(x4)));
                        break;
                    }
                }
            }
            ++ix;
        }
    }
}

