/*
 * Decompiled with CFR 0.152.
 */
package besom.json;

import besom.json.ParserInput$;
import besom.json.ParserInput$Line$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface ParserInput {
    public static ByteArrayBasedParserInput apply(byte[] byArray) {
        return ParserInput$.MODULE$.apply(byArray);
    }

    public static CharArrayBasedParserInput apply(char[] cArray) {
        return ParserInput$.MODULE$.apply(cArray);
    }

    public static StringBasedParserInput apply(String string) {
        return ParserInput$.MODULE$.apply(string);
    }

    public char nextChar();

    public char nextUtf8Char();

    public int cursor();

    public int length();

    public String sliceString(int var1, int var2);

    public char[] sliceCharArray(int var1, int var2);

    public Line getLine(int var1);

    public static class ByteArrayBasedParserInput
    extends IndexedBytesParserInput {
        private final byte[] bytes;

        public ByteArrayBasedParserInput(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte byteAt(int offset) {
            return this.bytes[offset];
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.bytes, start, end - start, ParserInput$.besom$json$ParserInput$$$UTF8);
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return ParserInput$.besom$json$ParserInput$$$UTF8.decode(ByteBuffer.wrap(Arrays.copyOfRange(this.bytes, start, end))).array();
        }
    }

    public static class CharArrayBasedParserInput
    extends DefaultParserInput {
        private final char[] chars;

        public CharArrayBasedParserInput(char[] chars) {
            this.chars = chars;
        }

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            if (this._cursor() < this.chars.length) {
                return this.chars[this._cursor()];
            }
            return '\uffff';
        }

        @Override
        public char nextUtf8Char() {
            return this.nextChar();
        }

        @Override
        public int length() {
            return this.chars.length;
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.chars, start, end - start);
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return Arrays.copyOfRange(this.chars, start, end);
        }
    }

    public static abstract class DefaultParserInput
    implements ParserInput {
        private int _cursor = -1;

        public int _cursor() {
            return this._cursor;
        }

        public void _cursor_$eq(int x$1) {
            this._cursor = x$1;
        }

        @Override
        public int cursor() {
            return this._cursor();
        }

        @Override
        public Line getLine(int index) {
            StringBuilder sb = new StringBuilder();
            int savedCursor = this._cursor();
            this._cursor_$eq(-1);
            Line line = this.rec$1(index, sb, 0, 0, 1);
            this._cursor_$eq(savedCursor);
            return line;
        }

        private final Line rec$1(int index$1, StringBuilder sb$1, int ix, int lineStartIx, int lineNr) {
            while (true) {
                char c;
                if ('\n' == (c = this.nextUtf8Char()) && index$1 > ix) {
                    sb$1.setLength(0);
                    int n = ix + 1;
                    int n2 = ix + 1;
                    int n3 = lineNr + 1;
                    ix = n;
                    lineStartIx = n2;
                    lineNr = n3;
                    continue;
                }
                if ('\n' == c || '\uffff' == c) {
                    return ParserInput$Line$.MODULE$.apply(lineNr, index$1 - lineStartIx + 1, sb$1.toString());
                }
                char c2 = c;
                sb$1.append(c2);
                ++ix;
            }
        }
    }

    public static abstract class IndexedBytesParserInput
    extends DefaultParserInput {
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        private final CharBuffer charBuffer = CharBuffer.allocate(2);
        private final CharsetDecoder decoder = ParserInput$.besom$json$ParserInput$$$UTF8.newDecoder();

        @Override
        public abstract int length();

        public abstract byte byteAt(int var1);

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            if (this._cursor() < this.length()) {
                return (char)(this.byteAt(this._cursor()) & 0xFF);
            }
            return '\uffff';
        }

        @Override
        public char nextUtf8Char() {
            if (this.charBuffer.position() > 0) {
                char result = this.charBuffer.get();
                this.charBuffer.clear();
                return result;
            }
            this._cursor_$eq(this._cursor() + 1);
            if (this._cursor() < this.length()) {
                byte by = this.byteAt(this._cursor());
                if (by >= 0) {
                    return (char)by;
                }
                if ((by & 0xE0) == 192) {
                    return this.decode$1(by, 1);
                }
                if ((by & 0xF0) == 224) {
                    return this.decode$1(by, 2);
                }
                if ((by & 0xF8) == 240) {
                    return this.decode$1(by, 3);
                }
                return '\ufffd';
            }
            return '\uffff';
        }

        private final char decode$1(byte by, int remainingBytes) {
            block2: {
                while (true) {
                    this.byteBuffer.put(by);
                    if (remainingBytes <= 0) break block2;
                    this._cursor_$eq(this._cursor() + 1);
                    if (this._cursor() >= this.length()) break;
                    byte by2 = this.byteAt(this._cursor());
                    int n = remainingBytes - 1;
                    by = by2;
                    remainingBytes = n;
                }
                return '\ufffd';
            }
            this.byteBuffer.flip();
            CoderResult coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
            this.charBuffer.flip();
            char result = coderResult.isUnderflow() & this.charBuffer.hasRemaining() ? (char)this.charBuffer.get() : (char)'\ufffd';
            this.byteBuffer.clear();
            if (!this.charBuffer.hasRemaining()) {
                this.charBuffer.clear();
            }
            return result;
        }
    }

    public static class Line
    implements Product,
    Serializable {
        private final int lineNr;
        private final int column;
        private final String text;

        public static Line apply(int n, int n2, String string) {
            return ParserInput$Line$.MODULE$.apply(n, n2, string);
        }

        public static Line fromProduct(Product product) {
            return ParserInput$Line$.MODULE$.fromProduct(product);
        }

        public static Line unapply(Line line) {
            return ParserInput$Line$.MODULE$.unapply(line);
        }

        public Line(int lineNr, int column, String text) {
            this.lineNr = lineNr;
            this.column = column;
            this.text = text;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNr());
            n = Statics.mix((int)n, (int)this.column());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Line)) return false;
            Line line = (Line)object;
            if (this.lineNr() != line.lineNr()) return false;
            if (this.column() != line.column()) return false;
            String string = this.text();
            String string2 = line.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!line.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Line;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Line";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineNr";
                }
                case 1: {
                    return "column";
                }
                case 2: {
                    return "text";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int lineNr() {
            return this.lineNr;
        }

        public int column() {
            return this.column;
        }

        public String text() {
            return this.text;
        }

        public Line copy(int lineNr, int column, String text) {
            return new Line(lineNr, column, text);
        }

        public int copy$default$1() {
            return this.lineNr();
        }

        public int copy$default$2() {
            return this.column();
        }

        public String copy$default$3() {
            return this.text();
        }

        public int _1() {
            return this.lineNr();
        }

        public int _2() {
            return this.column();
        }

        public String _3() {
            return this.text();
        }
    }

    public static class StringBasedParserInput
    extends DefaultParserInput {
        private final String string;

        public StringBasedParserInput(String string) {
            this.string = string;
        }

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            if (this._cursor() < this.string.length()) {
                return this.string.charAt(this._cursor());
            }
            return '\uffff';
        }

        @Override
        public char nextUtf8Char() {
            return this.nextChar();
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public String sliceString(int start, int end) {
            return this.string.substring(start, end);
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            char[] chars = new char[end - start];
            this.string.getChars(start, end, chars, 0);
            return chars;
        }
    }
}

