package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.ProviderResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Provider private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId]
) extends ProviderResource derives ResourceDecoder

object Provider:
  given outputOps: {} with
    extension(output: Output[Provider])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)

def provider(using ctx: Context)(
  name: NonEmptyString,
  args: ProviderArgs = ProviderArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Provider] = 
  ctx.registerResource[Provider, ProviderArgs]("pulumi:provider:random", name, args, opts)

