package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomId private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  b64Std: Output[String],
  b64Url: Output[String],
  byteLength: Output[Int],
  dec: Output[String],
  hex: Output[String],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  prefix: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object RandomId:
  given outputOps: {} with
    extension(output: Output[RandomId])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def b64Std: Output[String] = output.flatMap(_.b64Std)
      def b64Url: Output[String] = output.flatMap(_.b64Url)
      def byteLength: Output[Int] = output.flatMap(_.byteLength)
      def dec: Output[String] = output.flatMap(_.dec)
      def hex: Output[String] = output.flatMap(_.hex)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def prefix: Output[Option[String]] = output.flatMap(_.prefix)

def randomId(using ctx: Context)(
  name: NonEmptyString,
  args: RandomIdArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomId] = 
  ctx.registerResource[RandomId, RandomIdArgs]("random:index/randomId:RandomId", name, args, opts)

