package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RandomIdArgs private(
  byteLength: Output[Int],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  prefix: Output[Option[String]]
) derives ArgsEncoder

object RandomIdArgs:
  def apply(
    byteLength: Input[Int],
    keepers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    prefix: Input.Optional[String] = None
  )(using Context): RandomIdArgs =
    new RandomIdArgs(
      byteLength = byteLength.asOutput(isSecret = false),
      keepers = keepers.asOptionOutput(isSecret = false),
      prefix = prefix.asOptionOutput(isSecret = false)
    )
