package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomInteger private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  max: Output[Int],
  min: Output[Int],
  result: Output[Int],
  seed: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object RandomInteger:
  given outputOps: {} with
    extension(output: Output[RandomInteger])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def max: Output[Int] = output.flatMap(_.max)
      def min: Output[Int] = output.flatMap(_.min)
      def result: Output[Int] = output.flatMap(_.result)
      def seed: Output[Option[String]] = output.flatMap(_.seed)

def randomInteger(using ctx: Context)(
  name: NonEmptyString,
  args: RandomIntegerArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomInteger] = 
  ctx.registerResource[RandomInteger, RandomIntegerArgs]("random:index/randomInteger:RandomInteger", name, args, opts)

