package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RandomIntegerArgs private(
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  max: Output[Int],
  min: Output[Int],
  seed: Output[Option[String]]
) derives ArgsEncoder

object RandomIntegerArgs:
  def apply(
    keepers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    max: Input[Int],
    min: Input[Int],
    seed: Input.Optional[String] = None
  )(using Context): RandomIntegerArgs =
    new RandomIntegerArgs(
      keepers = keepers.asOptionOutput(isSecret = false),
      max = max.asOutput(isSecret = false),
      min = min.asOutput(isSecret = false),
      seed = seed.asOptionOutput(isSecret = false)
    )
