package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomPassword private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  bcryptHash: Output[String],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  length: Output[Int],
  lower: Output[Boolean],
  minLower: Output[Int],
  minNumeric: Output[Int],
  minSpecial: Output[Int],
  minUpper: Output[Int],
  number: Output[Boolean],
  numeric: Output[Boolean],
  overrideSpecial: Output[Option[String]],
  result: Output[String],
  special: Output[Boolean],
  upper: Output[Boolean]
) extends CustomResource derives ResourceDecoder

object RandomPassword:
  given outputOps: {} with
    extension(output: Output[RandomPassword])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def bcryptHash: Output[String] = output.flatMap(_.bcryptHash)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def length: Output[Int] = output.flatMap(_.length)
      def lower: Output[Boolean] = output.flatMap(_.lower)
      def minLower: Output[Int] = output.flatMap(_.minLower)
      def minNumeric: Output[Int] = output.flatMap(_.minNumeric)
      def minSpecial: Output[Int] = output.flatMap(_.minSpecial)
      def minUpper: Output[Int] = output.flatMap(_.minUpper)
      def number: Output[Boolean] = output.flatMap(_.number)
      def numeric: Output[Boolean] = output.flatMap(_.numeric)
      def overrideSpecial: Output[Option[String]] = output.flatMap(_.overrideSpecial)
      def result: Output[String] = output.flatMap(_.result)
      def special: Output[Boolean] = output.flatMap(_.special)
      def upper: Output[Boolean] = output.flatMap(_.upper)

def randomPassword(using ctx: Context)(
  name: NonEmptyString,
  args: RandomPasswordArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomPassword] = 
  ctx.registerResource[RandomPassword, RandomPasswordArgs]("random:index/randomPassword:RandomPassword", name, args, opts)

