package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RandomPasswordArgs private(
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  length: Output[Int],
  lower: Output[Option[Boolean]],
  minLower: Output[Option[Int]],
  minNumeric: Output[Option[Int]],
  minSpecial: Output[Option[Int]],
  minUpper: Output[Option[Int]],
  number: Output[Option[Boolean]],
  numeric: Output[Option[Boolean]],
  overrideSpecial: Output[Option[String]],
  special: Output[Option[Boolean]],
  upper: Output[Option[Boolean]]
) derives ArgsEncoder

object RandomPasswordArgs:
  def apply(
    keepers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    length: Input[Int],
    lower: Input.Optional[Boolean] = None,
    minLower: Input.Optional[Int] = None,
    minNumeric: Input.Optional[Int] = None,
    minSpecial: Input.Optional[Int] = None,
    minUpper: Input.Optional[Int] = None,
    number: Input.Optional[Boolean] = None,
    numeric: Input.Optional[Boolean] = None,
    overrideSpecial: Input.Optional[String] = None,
    special: Input.Optional[Boolean] = None,
    upper: Input.Optional[Boolean] = None
  )(using Context): RandomPasswordArgs =
    new RandomPasswordArgs(
      keepers = keepers.asOptionOutput(isSecret = false),
      length = length.asOutput(isSecret = false),
      lower = lower.asOptionOutput(isSecret = false),
      minLower = minLower.asOptionOutput(isSecret = false),
      minNumeric = minNumeric.asOptionOutput(isSecret = false),
      minSpecial = minSpecial.asOptionOutput(isSecret = false),
      minUpper = minUpper.asOptionOutput(isSecret = false),
      number = number.asOptionOutput(isSecret = false),
      numeric = numeric.asOptionOutput(isSecret = false),
      overrideSpecial = overrideSpecial.asOptionOutput(isSecret = false),
      special = special.asOptionOutput(isSecret = false),
      upper = upper.asOptionOutput(isSecret = false)
    )
