package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomPet private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  length: Output[Int],
  prefix: Output[Option[String]],
  separator: Output[String]
) extends CustomResource derives ResourceDecoder

object RandomPet:
  given outputOps: {} with
    extension(output: Output[RandomPet])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def length: Output[Int] = output.flatMap(_.length)
      def prefix: Output[Option[String]] = output.flatMap(_.prefix)
      def separator: Output[String] = output.flatMap(_.separator)

def randomPet(using ctx: Context)(
  name: NonEmptyString,
  args: RandomPetArgs = RandomPetArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomPet] = 
  ctx.registerResource[RandomPet, RandomPetArgs]("random:index/randomPet:RandomPet", name, args, opts)

