package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RandomPetArgs private(
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  length: Output[Option[Int]],
  prefix: Output[Option[String]],
  separator: Output[Option[String]]
) derives ArgsEncoder

object RandomPetArgs:
  def apply(
    keepers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    length: Input.Optional[Int] = None,
    prefix: Input.Optional[String] = None,
    separator: Input.Optional[String] = None
  )(using Context): RandomPetArgs =
    new RandomPetArgs(
      keepers = keepers.asOptionOutput(isSecret = false),
      length = length.asOptionOutput(isSecret = false),
      prefix = prefix.asOptionOutput(isSecret = false),
      separator = separator.asOptionOutput(isSecret = false)
    )
