package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomShuffle private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  inputs: Output[scala.collection.immutable.List[String]],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  resultCount: Output[Option[Int]],
  results: Output[scala.collection.immutable.List[String]],
  seed: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object RandomShuffle:
  given outputOps: {} with
    extension(output: Output[RandomShuffle])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def inputs: Output[scala.collection.immutable.List[String]] = output.flatMap(_.inputs)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def resultCount: Output[Option[Int]] = output.flatMap(_.resultCount)
      def results: Output[scala.collection.immutable.List[String]] = output.flatMap(_.results)
      def seed: Output[Option[String]] = output.flatMap(_.seed)

def randomShuffle(using ctx: Context)(
  name: NonEmptyString,
  args: RandomShuffleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomShuffle] = 
  ctx.registerResource[RandomShuffle, RandomShuffleArgs]("random:index/randomShuffle:RandomShuffle", name, args, opts)

