package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RandomShuffleArgs private(
  inputs: Output[scala.collection.immutable.List[String]],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  resultCount: Output[Option[Int]],
  seed: Output[Option[String]]
) derives ArgsEncoder

object RandomShuffleArgs:
  def apply(
    inputs: Input[List[Input[String]]],
    keepers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    resultCount: Input.Optional[Int] = None,
    seed: Input.Optional[String] = None
  )(using Context): RandomShuffleArgs =
    new RandomShuffleArgs(
      inputs = inputs.asOutput(isSecret = false),
      keepers = keepers.asOptionOutput(isSecret = false),
      resultCount = resultCount.asOptionOutput(isSecret = false),
      seed = seed.asOptionOutput(isSecret = false)
    )
