package besom.api.random

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RandomUuid private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  keepers: Output[Option[scala.Predef.Map[String, String]]],
  result: Output[String]
) extends CustomResource derives ResourceDecoder

object RandomUuid:
  given outputOps: {} with
    extension(output: Output[RandomUuid])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def keepers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.keepers)
      def result: Output[String] = output.flatMap(_.result)

def randomUuid(using ctx: Context)(
  name: NonEmptyString,
  args: RandomUuidArgs = RandomUuidArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RandomUuid] = 
  ctx.registerResource[RandomUuid, RandomUuidArgs]("random:index/randomUuid:RandomUuid", name, args, opts)

