// Generated by the Scala Plugin for the Protocol Buffer Compiler.
// Do not edit!

package pulumirpc.resource

/** RegisterResourceRequest contains information about a resource object that was newly allocated.
  *
  * @param type
  *   the type of the object allocated.
  * @param name
  *   the name, for URN purposes, of the object.
  * @param parent
  *   an optional parent URN that this child resource belongs to.
  * @param custom
  *   true if the resource is a custom, managed by a plugin's CRUD operations.
  * @param object
  *   an object produced by the interpreter/source.
  * @param protect
  *   true if the resource should be marked protected.
  * @param dependencies
  *   a list of URNs that this resource depends on, as observed by the language host.
  * @param provider
  *   an optional reference to the provider to manage this resource's CRUD operations.
  * @param propertyDependencies
  *   a map from property keys to the dependencies of the property.
  * @param deleteBeforeReplace
  *   true if this resource should be deleted before replacement.
  * @param version
  *   the version of the provider to use when servicing this request.
  * @param ignoreChanges
  *   a list of property selectors to ignore during updates.
  * @param acceptSecrets
  *   when true operations should return secrets as strongly typed.
  * @param additionalSecretOutputs
  *   a list of output properties that should also be treated as secret, in addition to ones we detect.
  * @param aliasURNs
  *   a list of additional URNs that should be considered the same.
  * @param importId
  *   if set, this resource's state should be imported from the given ID.
  * @param customTimeouts
  *   ability to pass a custom Timeout block.
  * @param deleteBeforeReplaceDefined
  *   true if the deleteBeforeReplace property should be treated as defined even if it is false.
  * @param supportsPartialValues
  *   true if the request is from an SDK that supports partially-known properties during preview.
  * @param remote
  *   true if the resource is a plugin-managed component resource.
  * @param acceptResources
  *   when true operations should return resource references as strongly typed.
  * @param providers
  *   an optional reference to the provider map to manage this resource's CRUD operations.
  * @param replaceOnChanges
  *   a list of properties that if changed should force a replacement.
  * @param pluginDownloadURL
  *   the server URL of the provider to use when servicing this request.
  * @param pluginChecksums
  *   a map of checksums expected for the provider plugin.
  * @param retainOnDelete
  *   if true the engine will not call the resource providers delete method for this resource.
  * @param aliases
  *   a list of additional aliases that should be considered the same.
  * @param deletedWith
  *   if set the engine will not call the resource providers delete method for this resource when specified resource is deleted.
  * @param aliasSpecs
  *   Indicates that alias specs are specified correctly according to the spec.
  *   Older versions of the Node.js SDK did not send alias specs correctly.
  *   If this is not set to true and the engine detects the request is from the
  *   Node.js runtime, the engine will transform incorrect alias specs into
  *   correct ones.
  *   Other SDKs that are correctly specifying alias specs could set this to
  *   true, but it's not necessary.
  * @param sourcePosition
  *   the optional source position of the user code that initiated the register.
  * @param transforms
  *   a list of transforms to apply to the resource before registering it.
  * @param supportsResultReporting
  *   true if the request is from an SDK that supports the result field in the response.
  * @param packageRef
  *   a reference from RegisterProviderRequest.
  */
@SerialVersionUID(0L)
final case class RegisterResourceRequest(
    `type`: _root_.scala.Predef.String = "",
    name: _root_.scala.Predef.String = "",
    parent: _root_.scala.Predef.String = "",
    custom: _root_.scala.Boolean = false,
    `object`: _root_.scala.Option[com.google.protobuf.struct.Struct] = _root_.scala.None,
    protect: _root_.scala.Boolean = false,
    dependencies: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
    provider: _root_.scala.Predef.String = "",
    propertyDependencies: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = _root_.scala.collection.immutable.Map.empty,
    deleteBeforeReplace: _root_.scala.Boolean = false,
    version: _root_.scala.Predef.String = "",
    ignoreChanges: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
    acceptSecrets: _root_.scala.Boolean = false,
    additionalSecretOutputs: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
    aliasURNs: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
    importId: _root_.scala.Predef.String = "",
    customTimeouts: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] = _root_.scala.None,
    deleteBeforeReplaceDefined: _root_.scala.Boolean = false,
    supportsPartialValues: _root_.scala.Boolean = false,
    remote: _root_.scala.Boolean = false,
    acceptResources: _root_.scala.Boolean = false,
    providers: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.scala.Predef.String] = _root_.scala.collection.immutable.Map.empty,
    replaceOnChanges: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
    pluginDownloadURL: _root_.scala.Predef.String = "",
    pluginChecksums: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString] = _root_.scala.collection.immutable.Map.empty,
    retainOnDelete: _root_.scala.Boolean = false,
    aliases: _root_.scala.Seq[pulumirpc.alias.Alias] = _root_.scala.Seq.empty,
    deletedWith: _root_.scala.Predef.String = "",
    aliasSpecs: _root_.scala.Boolean = false,
    sourcePosition: _root_.scala.Option[pulumirpc.source.SourcePosition] = _root_.scala.None,
    transforms: _root_.scala.Seq[pulumirpc.callback.Callback] = _root_.scala.Seq.empty,
    supportsResultReporting: _root_.scala.Boolean = false,
    packageRef: _root_.scala.Predef.String = "",
    unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
    ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[RegisterResourceRequest] {
    @transient
    private var __serializedSizeMemoized: _root_.scala.Int = 0
    private def __computeSerializedSize(): _root_.scala.Int = {
      var __size = 0
      
      {
        val __value = `type`
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
        }
      };
      
      {
        val __value = name
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(2, __value)
        }
      };
      
      {
        val __value = parent
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(3, __value)
        }
      };
      
      {
        val __value = custom
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(4, __value)
        }
      };
      if (`object`.isDefined) {
        val __value = `object`.get
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = protect
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(6, __value)
        }
      };
      dependencies.foreach { __item =>
        val __value = __item
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(7, __value)
      }
      
      {
        val __value = provider
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(8, __value)
        }
      };
      propertyDependencies.foreach { __item =>
        val __value = pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toBase(__item)
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      
      {
        val __value = deleteBeforeReplace
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(10, __value)
        }
      };
      
      {
        val __value = version
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(11, __value)
        }
      };
      ignoreChanges.foreach { __item =>
        val __value = __item
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(12, __value)
      }
      
      {
        val __value = acceptSecrets
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(13, __value)
        }
      };
      additionalSecretOutputs.foreach { __item =>
        val __value = __item
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(14, __value)
      }
      aliasURNs.foreach { __item =>
        val __value = __item
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(15, __value)
      }
      
      {
        val __value = importId
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(16, __value)
        }
      };
      if (customTimeouts.isDefined) {
        val __value = customTimeouts.get
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = deleteBeforeReplaceDefined
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(18, __value)
        }
      };
      
      {
        val __value = supportsPartialValues
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(19, __value)
        }
      };
      
      {
        val __value = remote
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(20, __value)
        }
      };
      
      {
        val __value = acceptResources
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(21, __value)
        }
      };
      providers.foreach { __item =>
        val __value = pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toBase(__item)
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      replaceOnChanges.foreach { __item =>
        val __value = __item
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(23, __value)
      }
      
      {
        val __value = pluginDownloadURL
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(24, __value)
        }
      };
      pluginChecksums.foreach { __item =>
        val __value = pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toBase(__item)
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      
      {
        val __value = retainOnDelete
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(25, __value)
        }
      };
      aliases.foreach { __item =>
        val __value = __item
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      
      {
        val __value = deletedWith
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(27, __value)
        }
      };
      
      {
        val __value = aliasSpecs
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(28, __value)
        }
      };
      if (sourcePosition.isDefined) {
        val __value = sourcePosition.get
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      transforms.foreach { __item =>
        val __value = __item
        __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      
      {
        val __value = supportsResultReporting
        if (__value != false) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBoolSize(32, __value)
        }
      };
      
      {
        val __value = packageRef
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(33, __value)
        }
      };
      __size += unknownFields.serializedSize
      __size
    }
    override def serializedSize: _root_.scala.Int = {
      var __size = __serializedSizeMemoized
      if (__size == 0) {
        __size = __computeSerializedSize() + 1
        __serializedSizeMemoized = __size
      }
      __size - 1
      
    }
    def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
      {
        val __v = `type`
        if (!__v.isEmpty) {
          _output__.writeString(1, __v)
        }
      };
      {
        val __v = name
        if (!__v.isEmpty) {
          _output__.writeString(2, __v)
        }
      };
      {
        val __v = parent
        if (!__v.isEmpty) {
          _output__.writeString(3, __v)
        }
      };
      {
        val __v = custom
        if (__v != false) {
          _output__.writeBool(4, __v)
        }
      };
      `object`.foreach { __v =>
        val __m = __v
        _output__.writeTag(5, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      {
        val __v = protect
        if (__v != false) {
          _output__.writeBool(6, __v)
        }
      };
      dependencies.foreach { __v =>
        val __m = __v
        _output__.writeString(7, __m)
      };
      {
        val __v = provider
        if (!__v.isEmpty) {
          _output__.writeString(8, __v)
        }
      };
      propertyDependencies.foreach { __v =>
        val __m = pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toBase(__v)
        _output__.writeTag(9, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      {
        val __v = deleteBeforeReplace
        if (__v != false) {
          _output__.writeBool(10, __v)
        }
      };
      {
        val __v = version
        if (!__v.isEmpty) {
          _output__.writeString(11, __v)
        }
      };
      ignoreChanges.foreach { __v =>
        val __m = __v
        _output__.writeString(12, __m)
      };
      {
        val __v = acceptSecrets
        if (__v != false) {
          _output__.writeBool(13, __v)
        }
      };
      additionalSecretOutputs.foreach { __v =>
        val __m = __v
        _output__.writeString(14, __m)
      };
      aliasURNs.foreach { __v =>
        val __m = __v
        _output__.writeString(15, __m)
      };
      {
        val __v = importId
        if (!__v.isEmpty) {
          _output__.writeString(16, __v)
        }
      };
      customTimeouts.foreach { __v =>
        val __m = __v
        _output__.writeTag(17, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      {
        val __v = deleteBeforeReplaceDefined
        if (__v != false) {
          _output__.writeBool(18, __v)
        }
      };
      {
        val __v = supportsPartialValues
        if (__v != false) {
          _output__.writeBool(19, __v)
        }
      };
      {
        val __v = remote
        if (__v != false) {
          _output__.writeBool(20, __v)
        }
      };
      {
        val __v = acceptResources
        if (__v != false) {
          _output__.writeBool(21, __v)
        }
      };
      providers.foreach { __v =>
        val __m = pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toBase(__v)
        _output__.writeTag(22, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      replaceOnChanges.foreach { __v =>
        val __m = __v
        _output__.writeString(23, __m)
      };
      {
        val __v = pluginDownloadURL
        if (!__v.isEmpty) {
          _output__.writeString(24, __v)
        }
      };
      {
        val __v = retainOnDelete
        if (__v != false) {
          _output__.writeBool(25, __v)
        }
      };
      aliases.foreach { __v =>
        val __m = __v
        _output__.writeTag(26, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      {
        val __v = deletedWith
        if (!__v.isEmpty) {
          _output__.writeString(27, __v)
        }
      };
      {
        val __v = aliasSpecs
        if (__v != false) {
          _output__.writeBool(28, __v)
        }
      };
      sourcePosition.foreach { __v =>
        val __m = __v
        _output__.writeTag(29, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      pluginChecksums.foreach { __v =>
        val __m = pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toBase(__v)
        _output__.writeTag(30, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      transforms.foreach { __v =>
        val __m = __v
        _output__.writeTag(31, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      {
        val __v = supportsResultReporting
        if (__v != false) {
          _output__.writeBool(32, __v)
        }
      };
      {
        val __v = packageRef
        if (!__v.isEmpty) {
          _output__.writeString(33, __v)
        }
      };
      unknownFields.writeTo(_output__)
    }
    def withType(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(`type` = __v)
    def withName(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(name = __v)
    def withParent(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(parent = __v)
    def withCustom(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(custom = __v)
    def getObject: com.google.protobuf.struct.Struct = `object`.getOrElse(com.google.protobuf.struct.Struct.defaultInstance)
    def clearObject: RegisterResourceRequest = copy(`object` = _root_.scala.None)
    def withObject(__v: com.google.protobuf.struct.Struct): RegisterResourceRequest = copy(`object` = Option(__v))
    def withProtect(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(protect = __v)
    def clearDependencies = copy(dependencies = _root_.scala.Seq.empty)
    def addDependencies(__vs: _root_.scala.Predef.String *): RegisterResourceRequest = addAllDependencies(__vs)
    def addAllDependencies(__vs: Iterable[_root_.scala.Predef.String]): RegisterResourceRequest = copy(dependencies = dependencies ++ __vs)
    def withDependencies(__v: _root_.scala.Seq[_root_.scala.Predef.String]): RegisterResourceRequest = copy(dependencies = __v)
    def withProvider(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(provider = __v)
    def clearPropertyDependencies = copy(propertyDependencies = _root_.scala.collection.immutable.Map.empty)
    def addPropertyDependencies(__vs: (_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies) *): RegisterResourceRequest = addAllPropertyDependencies(__vs)
    def addAllPropertyDependencies(__vs: Iterable[(_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies)]): RegisterResourceRequest = copy(propertyDependencies = propertyDependencies ++ __vs)
    def withPropertyDependencies(__v: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]): RegisterResourceRequest = copy(propertyDependencies = __v)
    def withDeleteBeforeReplace(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(deleteBeforeReplace = __v)
    def withVersion(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(version = __v)
    def clearIgnoreChanges = copy(ignoreChanges = _root_.scala.Seq.empty)
    def addIgnoreChanges(__vs: _root_.scala.Predef.String *): RegisterResourceRequest = addAllIgnoreChanges(__vs)
    def addAllIgnoreChanges(__vs: Iterable[_root_.scala.Predef.String]): RegisterResourceRequest = copy(ignoreChanges = ignoreChanges ++ __vs)
    def withIgnoreChanges(__v: _root_.scala.Seq[_root_.scala.Predef.String]): RegisterResourceRequest = copy(ignoreChanges = __v)
    def withAcceptSecrets(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(acceptSecrets = __v)
    def clearAdditionalSecretOutputs = copy(additionalSecretOutputs = _root_.scala.Seq.empty)
    def addAdditionalSecretOutputs(__vs: _root_.scala.Predef.String *): RegisterResourceRequest = addAllAdditionalSecretOutputs(__vs)
    def addAllAdditionalSecretOutputs(__vs: Iterable[_root_.scala.Predef.String]): RegisterResourceRequest = copy(additionalSecretOutputs = additionalSecretOutputs ++ __vs)
    def withAdditionalSecretOutputs(__v: _root_.scala.Seq[_root_.scala.Predef.String]): RegisterResourceRequest = copy(additionalSecretOutputs = __v)
    def clearAliasURNs = copy(aliasURNs = _root_.scala.Seq.empty)
    def addAliasURNs(__vs: _root_.scala.Predef.String *): RegisterResourceRequest = addAllAliasURNs(__vs)
    def addAllAliasURNs(__vs: Iterable[_root_.scala.Predef.String]): RegisterResourceRequest = copy(aliasURNs = aliasURNs ++ __vs)
    def withAliasURNs(__v: _root_.scala.Seq[_root_.scala.Predef.String]): RegisterResourceRequest = copy(aliasURNs = __v)
    def withImportId(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(importId = __v)
    def getCustomTimeouts: pulumirpc.resource.RegisterResourceRequest.CustomTimeouts = customTimeouts.getOrElse(pulumirpc.resource.RegisterResourceRequest.CustomTimeouts.defaultInstance)
    def clearCustomTimeouts: RegisterResourceRequest = copy(customTimeouts = _root_.scala.None)
    def withCustomTimeouts(__v: pulumirpc.resource.RegisterResourceRequest.CustomTimeouts): RegisterResourceRequest = copy(customTimeouts = Option(__v))
    def withDeleteBeforeReplaceDefined(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(deleteBeforeReplaceDefined = __v)
    def withSupportsPartialValues(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(supportsPartialValues = __v)
    def withRemote(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(remote = __v)
    def withAcceptResources(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(acceptResources = __v)
    def clearProviders = copy(providers = _root_.scala.collection.immutable.Map.empty)
    def addProviders(__vs: (_root_.scala.Predef.String, _root_.scala.Predef.String) *): RegisterResourceRequest = addAllProviders(__vs)
    def addAllProviders(__vs: Iterable[(_root_.scala.Predef.String, _root_.scala.Predef.String)]): RegisterResourceRequest = copy(providers = providers ++ __vs)
    def withProviders(__v: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.scala.Predef.String]): RegisterResourceRequest = copy(providers = __v)
    def clearReplaceOnChanges = copy(replaceOnChanges = _root_.scala.Seq.empty)
    def addReplaceOnChanges(__vs: _root_.scala.Predef.String *): RegisterResourceRequest = addAllReplaceOnChanges(__vs)
    def addAllReplaceOnChanges(__vs: Iterable[_root_.scala.Predef.String]): RegisterResourceRequest = copy(replaceOnChanges = replaceOnChanges ++ __vs)
    def withReplaceOnChanges(__v: _root_.scala.Seq[_root_.scala.Predef.String]): RegisterResourceRequest = copy(replaceOnChanges = __v)
    def withPluginDownloadURL(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(pluginDownloadURL = __v)
    def clearPluginChecksums = copy(pluginChecksums = _root_.scala.collection.immutable.Map.empty)
    def addPluginChecksums(__vs: (_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString) *): RegisterResourceRequest = addAllPluginChecksums(__vs)
    def addAllPluginChecksums(__vs: Iterable[(_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString)]): RegisterResourceRequest = copy(pluginChecksums = pluginChecksums ++ __vs)
    def withPluginChecksums(__v: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString]): RegisterResourceRequest = copy(pluginChecksums = __v)
    def withRetainOnDelete(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(retainOnDelete = __v)
    def clearAliases = copy(aliases = _root_.scala.Seq.empty)
    def addAliases(__vs: pulumirpc.alias.Alias *): RegisterResourceRequest = addAllAliases(__vs)
    def addAllAliases(__vs: Iterable[pulumirpc.alias.Alias]): RegisterResourceRequest = copy(aliases = aliases ++ __vs)
    def withAliases(__v: _root_.scala.Seq[pulumirpc.alias.Alias]): RegisterResourceRequest = copy(aliases = __v)
    def withDeletedWith(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(deletedWith = __v)
    def withAliasSpecs(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(aliasSpecs = __v)
    def getSourcePosition: pulumirpc.source.SourcePosition = sourcePosition.getOrElse(pulumirpc.source.SourcePosition.defaultInstance)
    def clearSourcePosition: RegisterResourceRequest = copy(sourcePosition = _root_.scala.None)
    def withSourcePosition(__v: pulumirpc.source.SourcePosition): RegisterResourceRequest = copy(sourcePosition = Option(__v))
    def clearTransforms = copy(transforms = _root_.scala.Seq.empty)
    def addTransforms(__vs: pulumirpc.callback.Callback *): RegisterResourceRequest = addAllTransforms(__vs)
    def addAllTransforms(__vs: Iterable[pulumirpc.callback.Callback]): RegisterResourceRequest = copy(transforms = transforms ++ __vs)
    def withTransforms(__v: _root_.scala.Seq[pulumirpc.callback.Callback]): RegisterResourceRequest = copy(transforms = __v)
    def withSupportsResultReporting(__v: _root_.scala.Boolean): RegisterResourceRequest = copy(supportsResultReporting = __v)
    def withPackageRef(__v: _root_.scala.Predef.String): RegisterResourceRequest = copy(packageRef = __v)
    def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
    def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
    def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
      (__fieldNumber: @_root_.scala.unchecked) match {
        case 1 => {
          val __t = `type`
          if (__t != "") __t else null
        }
        case 2 => {
          val __t = name
          if (__t != "") __t else null
        }
        case 3 => {
          val __t = parent
          if (__t != "") __t else null
        }
        case 4 => {
          val __t = custom
          if (__t != false) __t else null
        }
        case 5 => `object`.orNull
        case 6 => {
          val __t = protect
          if (__t != false) __t else null
        }
        case 7 => dependencies
        case 8 => {
          val __t = provider
          if (__t != "") __t else null
        }
        case 9 => propertyDependencies.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toBase(_)).toSeq
        case 10 => {
          val __t = deleteBeforeReplace
          if (__t != false) __t else null
        }
        case 11 => {
          val __t = version
          if (__t != "") __t else null
        }
        case 12 => ignoreChanges
        case 13 => {
          val __t = acceptSecrets
          if (__t != false) __t else null
        }
        case 14 => additionalSecretOutputs
        case 15 => aliasURNs
        case 16 => {
          val __t = importId
          if (__t != "") __t else null
        }
        case 17 => customTimeouts.orNull
        case 18 => {
          val __t = deleteBeforeReplaceDefined
          if (__t != false) __t else null
        }
        case 19 => {
          val __t = supportsPartialValues
          if (__t != false) __t else null
        }
        case 20 => {
          val __t = remote
          if (__t != false) __t else null
        }
        case 21 => {
          val __t = acceptResources
          if (__t != false) __t else null
        }
        case 22 => providers.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toBase(_)).toSeq
        case 23 => replaceOnChanges
        case 24 => {
          val __t = pluginDownloadURL
          if (__t != "") __t else null
        }
        case 30 => pluginChecksums.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toBase(_)).toSeq
        case 25 => {
          val __t = retainOnDelete
          if (__t != false) __t else null
        }
        case 26 => aliases
        case 27 => {
          val __t = deletedWith
          if (__t != "") __t else null
        }
        case 28 => {
          val __t = aliasSpecs
          if (__t != false) __t else null
        }
        case 29 => sourcePosition.orNull
        case 31 => transforms
        case 32 => {
          val __t = supportsResultReporting
          if (__t != false) __t else null
        }
        case 33 => {
          val __t = packageRef
          if (__t != "") __t else null
        }
      }
    }
    def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
      _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
      (__field.number: @_root_.scala.unchecked) match {
        case 1 => _root_.scalapb.descriptors.PString(`type`)
        case 2 => _root_.scalapb.descriptors.PString(name)
        case 3 => _root_.scalapb.descriptors.PString(parent)
        case 4 => _root_.scalapb.descriptors.PBoolean(custom)
        case 5 => `object`.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 6 => _root_.scalapb.descriptors.PBoolean(protect)
        case 7 => _root_.scalapb.descriptors.PRepeated(dependencies.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        case 8 => _root_.scalapb.descriptors.PString(provider)
        case 9 => _root_.scalapb.descriptors.PRepeated(propertyDependencies.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toBase(_).toPMessage).toVector)
        case 10 => _root_.scalapb.descriptors.PBoolean(deleteBeforeReplace)
        case 11 => _root_.scalapb.descriptors.PString(version)
        case 12 => _root_.scalapb.descriptors.PRepeated(ignoreChanges.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        case 13 => _root_.scalapb.descriptors.PBoolean(acceptSecrets)
        case 14 => _root_.scalapb.descriptors.PRepeated(additionalSecretOutputs.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        case 15 => _root_.scalapb.descriptors.PRepeated(aliasURNs.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        case 16 => _root_.scalapb.descriptors.PString(importId)
        case 17 => customTimeouts.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 18 => _root_.scalapb.descriptors.PBoolean(deleteBeforeReplaceDefined)
        case 19 => _root_.scalapb.descriptors.PBoolean(supportsPartialValues)
        case 20 => _root_.scalapb.descriptors.PBoolean(remote)
        case 21 => _root_.scalapb.descriptors.PBoolean(acceptResources)
        case 22 => _root_.scalapb.descriptors.PRepeated(providers.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toBase(_).toPMessage).toVector)
        case 23 => _root_.scalapb.descriptors.PRepeated(replaceOnChanges.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        case 24 => _root_.scalapb.descriptors.PString(pluginDownloadURL)
        case 30 => _root_.scalapb.descriptors.PRepeated(pluginChecksums.iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toBase(_).toPMessage).toVector)
        case 25 => _root_.scalapb.descriptors.PBoolean(retainOnDelete)
        case 26 => _root_.scalapb.descriptors.PRepeated(aliases.iterator.map(_.toPMessage).toVector)
        case 27 => _root_.scalapb.descriptors.PString(deletedWith)
        case 28 => _root_.scalapb.descriptors.PBoolean(aliasSpecs)
        case 29 => sourcePosition.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 31 => _root_.scalapb.descriptors.PRepeated(transforms.iterator.map(_.toPMessage).toVector)
        case 32 => _root_.scalapb.descriptors.PBoolean(supportsResultReporting)
        case 33 => _root_.scalapb.descriptors.PString(packageRef)
      }
    }
    def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
    def companion: pulumirpc.resource.RegisterResourceRequest.type = pulumirpc.resource.RegisterResourceRequest
    // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest])
}

object RegisterResourceRequest extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest] {
  implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest] = this
  def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest = {
    var __type: _root_.scala.Predef.String = ""
    var __name: _root_.scala.Predef.String = ""
    var __parent: _root_.scala.Predef.String = ""
    var __custom: _root_.scala.Boolean = false
    var __object: _root_.scala.Option[com.google.protobuf.struct.Struct] = _root_.scala.None
    var __protect: _root_.scala.Boolean = false
    val __dependencies: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
    var __provider: _root_.scala.Predef.String = ""
    val __propertyDependencies: _root_.scala.collection.mutable.Builder[(_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies), _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]] = _root_.scala.collection.immutable.Map.newBuilder[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]
    var __deleteBeforeReplace: _root_.scala.Boolean = false
    var __version: _root_.scala.Predef.String = ""
    val __ignoreChanges: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
    var __acceptSecrets: _root_.scala.Boolean = false
    val __additionalSecretOutputs: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
    val __aliasURNs: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
    var __importId: _root_.scala.Predef.String = ""
    var __customTimeouts: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] = _root_.scala.None
    var __deleteBeforeReplaceDefined: _root_.scala.Boolean = false
    var __supportsPartialValues: _root_.scala.Boolean = false
    var __remote: _root_.scala.Boolean = false
    var __acceptResources: _root_.scala.Boolean = false
    val __providers: _root_.scala.collection.mutable.Builder[(_root_.scala.Predef.String, _root_.scala.Predef.String), _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.scala.Predef.String]] = _root_.scala.collection.immutable.Map.newBuilder[_root_.scala.Predef.String, _root_.scala.Predef.String]
    val __replaceOnChanges: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
    var __pluginDownloadURL: _root_.scala.Predef.String = ""
    val __pluginChecksums: _root_.scala.collection.mutable.Builder[(_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString), _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString]] = _root_.scala.collection.immutable.Map.newBuilder[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString]
    var __retainOnDelete: _root_.scala.Boolean = false
    val __aliases: _root_.scala.collection.immutable.VectorBuilder[pulumirpc.alias.Alias] = new _root_.scala.collection.immutable.VectorBuilder[pulumirpc.alias.Alias]
    var __deletedWith: _root_.scala.Predef.String = ""
    var __aliasSpecs: _root_.scala.Boolean = false
    var __sourcePosition: _root_.scala.Option[pulumirpc.source.SourcePosition] = _root_.scala.None
    val __transforms: _root_.scala.collection.immutable.VectorBuilder[pulumirpc.callback.Callback] = new _root_.scala.collection.immutable.VectorBuilder[pulumirpc.callback.Callback]
    var __supportsResultReporting: _root_.scala.Boolean = false
    var __packageRef: _root_.scala.Predef.String = ""
    var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
    var _done__ = false
    while (!_done__) {
      val _tag__ = _input__.readTag()
      _tag__ match {
        case 0 => _done__ = true
        case 10 =>
          __type = _input__.readStringRequireUtf8()
        case 18 =>
          __name = _input__.readStringRequireUtf8()
        case 26 =>
          __parent = _input__.readStringRequireUtf8()
        case 32 =>
          __custom = _input__.readBool()
        case 42 =>
          __object = _root_.scala.Option(__object.fold(_root_.scalapb.LiteParser.readMessage[com.google.protobuf.struct.Struct](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
        case 48 =>
          __protect = _input__.readBool()
        case 58 =>
          __dependencies += _input__.readStringRequireUtf8()
        case 66 =>
          __provider = _input__.readStringRequireUtf8()
        case 74 =>
          __propertyDependencies += pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toCustom(_root_.scalapb.LiteParser.readMessage[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry](_input__))
        case 80 =>
          __deleteBeforeReplace = _input__.readBool()
        case 90 =>
          __version = _input__.readStringRequireUtf8()
        case 98 =>
          __ignoreChanges += _input__.readStringRequireUtf8()
        case 104 =>
          __acceptSecrets = _input__.readBool()
        case 114 =>
          __additionalSecretOutputs += _input__.readStringRequireUtf8()
        case 122 =>
          __aliasURNs += _input__.readStringRequireUtf8()
        case 130 =>
          __importId = _input__.readStringRequireUtf8()
        case 138 =>
          __customTimeouts = _root_.scala.Option(__customTimeouts.fold(_root_.scalapb.LiteParser.readMessage[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
        case 144 =>
          __deleteBeforeReplaceDefined = _input__.readBool()
        case 152 =>
          __supportsPartialValues = _input__.readBool()
        case 160 =>
          __remote = _input__.readBool()
        case 168 =>
          __acceptResources = _input__.readBool()
        case 178 =>
          __providers += pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toCustom(_root_.scalapb.LiteParser.readMessage[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry](_input__))
        case 186 =>
          __replaceOnChanges += _input__.readStringRequireUtf8()
        case 194 =>
          __pluginDownloadURL = _input__.readStringRequireUtf8()
        case 242 =>
          __pluginChecksums += pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toCustom(_root_.scalapb.LiteParser.readMessage[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry](_input__))
        case 200 =>
          __retainOnDelete = _input__.readBool()
        case 210 =>
          __aliases += _root_.scalapb.LiteParser.readMessage[pulumirpc.alias.Alias](_input__)
        case 218 =>
          __deletedWith = _input__.readStringRequireUtf8()
        case 224 =>
          __aliasSpecs = _input__.readBool()
        case 234 =>
          __sourcePosition = _root_.scala.Option(__sourcePosition.fold(_root_.scalapb.LiteParser.readMessage[pulumirpc.source.SourcePosition](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
        case 250 =>
          __transforms += _root_.scalapb.LiteParser.readMessage[pulumirpc.callback.Callback](_input__)
        case 256 =>
          __supportsResultReporting = _input__.readBool()
        case 266 =>
          __packageRef = _input__.readStringRequireUtf8()
        case tag =>
          if (_unknownFields__ == null) {
            _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
          }
          _unknownFields__.parseField(tag, _input__)
      }
    }
    pulumirpc.resource.RegisterResourceRequest(
        `type` = __type,
        name = __name,
        parent = __parent,
        custom = __custom,
        `object` = __object,
        protect = __protect,
        dependencies = __dependencies.result(),
        provider = __provider,
        propertyDependencies = __propertyDependencies.result(),
        deleteBeforeReplace = __deleteBeforeReplace,
        version = __version,
        ignoreChanges = __ignoreChanges.result(),
        acceptSecrets = __acceptSecrets,
        additionalSecretOutputs = __additionalSecretOutputs.result(),
        aliasURNs = __aliasURNs.result(),
        importId = __importId,
        customTimeouts = __customTimeouts,
        deleteBeforeReplaceDefined = __deleteBeforeReplaceDefined,
        supportsPartialValues = __supportsPartialValues,
        remote = __remote,
        acceptResources = __acceptResources,
        providers = __providers.result(),
        replaceOnChanges = __replaceOnChanges.result(),
        pluginDownloadURL = __pluginDownloadURL,
        pluginChecksums = __pluginChecksums.result(),
        retainOnDelete = __retainOnDelete,
        aliases = __aliases.result(),
        deletedWith = __deletedWith,
        aliasSpecs = __aliasSpecs,
        sourcePosition = __sourcePosition,
        transforms = __transforms.result(),
        supportsResultReporting = __supportsResultReporting,
        packageRef = __packageRef,
        unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
    )
  }
  implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest] = _root_.scalapb.descriptors.Reads{
    case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
      _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
      pulumirpc.resource.RegisterResourceRequest(
        `type` = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        name = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        parent = __fieldsMap.get(scalaDescriptor.findFieldByNumber(3).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        custom = __fieldsMap.get(scalaDescriptor.findFieldByNumber(4).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        `object` = __fieldsMap.get(scalaDescriptor.findFieldByNumber(5).get).flatMap(_.as[_root_.scala.Option[com.google.protobuf.struct.Struct]]),
        protect = __fieldsMap.get(scalaDescriptor.findFieldByNumber(6).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        dependencies = __fieldsMap.get(scalaDescriptor.findFieldByNumber(7).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty),
        provider = __fieldsMap.get(scalaDescriptor.findFieldByNumber(8).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        propertyDependencies = __fieldsMap.get(scalaDescriptor.findFieldByNumber(9).get).map(_.as[_root_.scala.Seq[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry]]).getOrElse(_root_.scala.Seq.empty).iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_propertyDependencies.toCustom(_)).toMap,
        deleteBeforeReplace = __fieldsMap.get(scalaDescriptor.findFieldByNumber(10).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        version = __fieldsMap.get(scalaDescriptor.findFieldByNumber(11).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        ignoreChanges = __fieldsMap.get(scalaDescriptor.findFieldByNumber(12).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty),
        acceptSecrets = __fieldsMap.get(scalaDescriptor.findFieldByNumber(13).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        additionalSecretOutputs = __fieldsMap.get(scalaDescriptor.findFieldByNumber(14).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty),
        aliasURNs = __fieldsMap.get(scalaDescriptor.findFieldByNumber(15).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty),
        importId = __fieldsMap.get(scalaDescriptor.findFieldByNumber(16).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        customTimeouts = __fieldsMap.get(scalaDescriptor.findFieldByNumber(17).get).flatMap(_.as[_root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts]]),
        deleteBeforeReplaceDefined = __fieldsMap.get(scalaDescriptor.findFieldByNumber(18).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        supportsPartialValues = __fieldsMap.get(scalaDescriptor.findFieldByNumber(19).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        remote = __fieldsMap.get(scalaDescriptor.findFieldByNumber(20).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        acceptResources = __fieldsMap.get(scalaDescriptor.findFieldByNumber(21).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        providers = __fieldsMap.get(scalaDescriptor.findFieldByNumber(22).get).map(_.as[_root_.scala.Seq[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry]]).getOrElse(_root_.scala.Seq.empty).iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_providers.toCustom(_)).toMap,
        replaceOnChanges = __fieldsMap.get(scalaDescriptor.findFieldByNumber(23).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty),
        pluginDownloadURL = __fieldsMap.get(scalaDescriptor.findFieldByNumber(24).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        pluginChecksums = __fieldsMap.get(scalaDescriptor.findFieldByNumber(30).get).map(_.as[_root_.scala.Seq[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry]]).getOrElse(_root_.scala.Seq.empty).iterator.map(pulumirpc.resource.RegisterResourceRequest._typemapper_pluginChecksums.toCustom(_)).toMap,
        retainOnDelete = __fieldsMap.get(scalaDescriptor.findFieldByNumber(25).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        aliases = __fieldsMap.get(scalaDescriptor.findFieldByNumber(26).get).map(_.as[_root_.scala.Seq[pulumirpc.alias.Alias]]).getOrElse(_root_.scala.Seq.empty),
        deletedWith = __fieldsMap.get(scalaDescriptor.findFieldByNumber(27).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
        aliasSpecs = __fieldsMap.get(scalaDescriptor.findFieldByNumber(28).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        sourcePosition = __fieldsMap.get(scalaDescriptor.findFieldByNumber(29).get).flatMap(_.as[_root_.scala.Option[pulumirpc.source.SourcePosition]]),
        transforms = __fieldsMap.get(scalaDescriptor.findFieldByNumber(31).get).map(_.as[_root_.scala.Seq[pulumirpc.callback.Callback]]).getOrElse(_root_.scala.Seq.empty),
        supportsResultReporting = __fieldsMap.get(scalaDescriptor.findFieldByNumber(32).get).map(_.as[_root_.scala.Boolean]).getOrElse(false),
        packageRef = __fieldsMap.get(scalaDescriptor.findFieldByNumber(33).get).map(_.as[_root_.scala.Predef.String]).getOrElse("")
      )
    case _ => throw new RuntimeException("Expected PMessage")
  }
  def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.ResourceProto.javaDescriptor.getMessageTypes().get(4)
  def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.ResourceProto.scalaDescriptor.messages(4)
  def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = {
    var __out: _root_.scalapb.GeneratedMessageCompanion[?] = null
    (__number: @_root_.scala.unchecked) match {
      case 5 => __out = com.google.protobuf.struct.Struct
      case 9 => __out = pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry
      case 17 => __out = pulumirpc.resource.RegisterResourceRequest.CustomTimeouts
      case 22 => __out = pulumirpc.resource.RegisterResourceRequest.ProvidersEntry
      case 30 => __out = pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry
      case 26 => __out = pulumirpc.alias.Alias
      case 29 => __out = pulumirpc.source.SourcePosition
      case 31 => __out = pulumirpc.callback.Callback
    }
    __out
  }
  lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] =
    Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]](
      _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependencies,
      _root_.pulumirpc.resource.RegisterResourceRequest.CustomTimeouts,
      _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry,
      _root_.pulumirpc.resource.RegisterResourceRequest.ProvidersEntry,
      _root_.pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry
    )
  def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
  lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest(
    `type` = "",
    name = "",
    parent = "",
    custom = false,
    `object` = _root_.scala.None,
    protect = false,
    dependencies = _root_.scala.Seq.empty,
    provider = "",
    propertyDependencies = _root_.scala.collection.immutable.Map.empty,
    deleteBeforeReplace = false,
    version = "",
    ignoreChanges = _root_.scala.Seq.empty,
    acceptSecrets = false,
    additionalSecretOutputs = _root_.scala.Seq.empty,
    aliasURNs = _root_.scala.Seq.empty,
    importId = "",
    customTimeouts = _root_.scala.None,
    deleteBeforeReplaceDefined = false,
    supportsPartialValues = false,
    remote = false,
    acceptResources = false,
    providers = _root_.scala.collection.immutable.Map.empty,
    replaceOnChanges = _root_.scala.Seq.empty,
    pluginDownloadURL = "",
    pluginChecksums = _root_.scala.collection.immutable.Map.empty,
    retainOnDelete = false,
    aliases = _root_.scala.Seq.empty,
    deletedWith = "",
    aliasSpecs = false,
    sourcePosition = _root_.scala.None,
    transforms = _root_.scala.Seq.empty,
    supportsResultReporting = false,
    packageRef = ""
  )
  /** PropertyDependencies describes the resources that a particular property depends on.
    *
    * @param urns
    *   A list of URNs this property depends on.
    */
  @SerialVersionUID(0L)
  final case class PropertyDependencies(
      urns: _root_.scala.Seq[_root_.scala.Predef.String] = _root_.scala.Seq.empty,
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[PropertyDependencies] {
      @transient
      private var __serializedSizeMemoized: _root_.scala.Int = 0
      private def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        urns.foreach { __item =>
          val __value = __item
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
        }
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        urns.foreach { __v =>
          val __m = __v
          _output__.writeString(1, __m)
        };
        unknownFields.writeTo(_output__)
      }
      def clearUrns = copy(urns = _root_.scala.Seq.empty)
      def addUrns(__vs: _root_.scala.Predef.String *): PropertyDependencies = addAllUrns(__vs)
      def addAllUrns(__vs: Iterable[_root_.scala.Predef.String]): PropertyDependencies = copy(urns = urns ++ __vs)
      def withUrns(__v: _root_.scala.Seq[_root_.scala.Predef.String]): PropertyDependencies = copy(urns = __v)
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => urns
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => _root_.scalapb.descriptors.PRepeated(urns.iterator.map(_root_.scalapb.descriptors.PString(_)).toVector)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: pulumirpc.resource.RegisterResourceRequest.PropertyDependencies.type = pulumirpc.resource.RegisterResourceRequest.PropertyDependencies
      // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest.PropertyDependencies])
  }
  
  object PropertyDependencies extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = this
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest.PropertyDependencies = {
      val __urns: _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String] = new _root_.scala.collection.immutable.VectorBuilder[_root_.scala.Predef.String]
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __urns += _input__.readStringRequireUtf8()
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            _unknownFields__.parseField(tag, _input__)
        }
      }
      pulumirpc.resource.RegisterResourceRequest.PropertyDependencies(
          urns = __urns.result(),
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        pulumirpc.resource.RegisterResourceRequest.PropertyDependencies(
          urns = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Seq[_root_.scala.Predef.String]]).getOrElse(_root_.scala.Seq.empty)
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.javaDescriptor.getNestedTypes().get(0)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.scalaDescriptor.nestedMessages(0)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = throw new MatchError(__number)
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest.PropertyDependencies(
      urns = _root_.scala.Seq.empty
    )
    implicit class PropertyDependenciesLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies](_l) {
      def urns: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.urns)((c_, f_) => c_.copy(urns = f_))
    }
    final val URNS_FIELD_NUMBER = 1
    def of(
      urns: _root_.scala.Seq[_root_.scala.Predef.String]
    ): _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependencies = _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependencies(
      urns
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest.PropertyDependencies])
  }
  
  /** CustomTimeouts allows a user to be able to create a set of custom timeout parameters.
    *
    * @param create
    *   The create resource timeout represented as a string e.g. 5m.
    * @param update
    *   The update resource timeout represented as a string e.g. 5m.
    * @param delete
    *   The delete resource timeout represented as a string e.g. 5m.
    */
  @SerialVersionUID(0L)
  final case class CustomTimeouts(
      create: _root_.scala.Predef.String = "",
      update: _root_.scala.Predef.String = "",
      delete: _root_.scala.Predef.String = "",
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[CustomTimeouts] {
      @transient
      private var __serializedSizeMemoized: _root_.scala.Int = 0
      private def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        
        {
          val __value = create
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
          }
        };
        
        {
          val __value = update
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(2, __value)
          }
        };
        
        {
          val __value = delete
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(3, __value)
          }
        };
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        {
          val __v = create
          if (!__v.isEmpty) {
            _output__.writeString(1, __v)
          }
        };
        {
          val __v = update
          if (!__v.isEmpty) {
            _output__.writeString(2, __v)
          }
        };
        {
          val __v = delete
          if (!__v.isEmpty) {
            _output__.writeString(3, __v)
          }
        };
        unknownFields.writeTo(_output__)
      }
      def withCreate(__v: _root_.scala.Predef.String): CustomTimeouts = copy(create = __v)
      def withUpdate(__v: _root_.scala.Predef.String): CustomTimeouts = copy(update = __v)
      def withDelete(__v: _root_.scala.Predef.String): CustomTimeouts = copy(delete = __v)
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => {
            val __t = create
            if (__t != "") __t else null
          }
          case 2 => {
            val __t = update
            if (__t != "") __t else null
          }
          case 3 => {
            val __t = delete
            if (__t != "") __t else null
          }
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => _root_.scalapb.descriptors.PString(create)
          case 2 => _root_.scalapb.descriptors.PString(update)
          case 3 => _root_.scalapb.descriptors.PString(delete)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: pulumirpc.resource.RegisterResourceRequest.CustomTimeouts.type = pulumirpc.resource.RegisterResourceRequest.CustomTimeouts
      // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest.CustomTimeouts])
  }
  
  object CustomTimeouts extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] = this
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest.CustomTimeouts = {
      var __create: _root_.scala.Predef.String = ""
      var __update: _root_.scala.Predef.String = ""
      var __delete: _root_.scala.Predef.String = ""
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __create = _input__.readStringRequireUtf8()
          case 18 =>
            __update = _input__.readStringRequireUtf8()
          case 26 =>
            __delete = _input__.readStringRequireUtf8()
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            _unknownFields__.parseField(tag, _input__)
        }
      }
      pulumirpc.resource.RegisterResourceRequest.CustomTimeouts(
          create = __create,
          update = __update,
          delete = __delete,
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        pulumirpc.resource.RegisterResourceRequest.CustomTimeouts(
          create = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
          update = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
          delete = __fieldsMap.get(scalaDescriptor.findFieldByNumber(3).get).map(_.as[_root_.scala.Predef.String]).getOrElse("")
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.javaDescriptor.getNestedTypes().get(1)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.scalaDescriptor.nestedMessages(1)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = throw new MatchError(__number)
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest.CustomTimeouts(
      create = "",
      update = "",
      delete = ""
    )
    implicit class CustomTimeoutsLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.CustomTimeouts]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest.CustomTimeouts](_l) {
      def create: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.create)((c_, f_) => c_.copy(create = f_))
      def update: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.update)((c_, f_) => c_.copy(update = f_))
      def delete: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.delete)((c_, f_) => c_.copy(delete = f_))
    }
    final val CREATE_FIELD_NUMBER = 1
    final val UPDATE_FIELD_NUMBER = 2
    final val DELETE_FIELD_NUMBER = 3
    def of(
      create: _root_.scala.Predef.String,
      update: _root_.scala.Predef.String,
      delete: _root_.scala.Predef.String
    ): _root_.pulumirpc.resource.RegisterResourceRequest.CustomTimeouts = _root_.pulumirpc.resource.RegisterResourceRequest.CustomTimeouts(
      create,
      update,
      delete
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest.CustomTimeouts])
  }
  
  @SerialVersionUID(0L)
  final case class PropertyDependenciesEntry(
      key: _root_.scala.Predef.String = "",
      value: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = _root_.scala.None,
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[PropertyDependenciesEntry] {
      @transient
      private var __serializedSizeMemoized: _root_.scala.Int = 0
      private def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        
        {
          val __value = key
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
          }
        };
        if (value.isDefined) {
          val __value = value.get
          __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
        };
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        {
          val __v = key
          if (!__v.isEmpty) {
            _output__.writeString(1, __v)
          }
        };
        value.foreach { __v =>
          val __m = __v
          _output__.writeTag(2, 2)
          _output__.writeUInt32NoTag(__m.serializedSize)
          __m.writeTo(_output__)
        };
        unknownFields.writeTo(_output__)
      }
      def withKey(__v: _root_.scala.Predef.String): PropertyDependenciesEntry = copy(key = __v)
      def getValue: pulumirpc.resource.RegisterResourceRequest.PropertyDependencies = value.getOrElse(pulumirpc.resource.RegisterResourceRequest.PropertyDependencies.defaultInstance)
      def clearValue: PropertyDependenciesEntry = copy(value = _root_.scala.None)
      def withValue(__v: pulumirpc.resource.RegisterResourceRequest.PropertyDependencies): PropertyDependenciesEntry = copy(value = Option(__v))
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => {
            val __t = key
            if (__t != "") __t else null
          }
          case 2 => value.orNull
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => _root_.scalapb.descriptors.PString(key)
          case 2 => value.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry.type = pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry
      // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest.PropertyDependenciesEntry])
  }
  
  object PropertyDependenciesEntry extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry] = this
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry = {
      var __key: _root_.scala.Predef.String = ""
      var __value: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = _root_.scala.None
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __key = _input__.readStringRequireUtf8()
          case 18 =>
            __value = _root_.scala.Option(__value.fold(_root_.scalapb.LiteParser.readMessage[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            _unknownFields__.parseField(tag, _input__)
        }
      }
      pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry(
          key = __key,
          value = __value,
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry(
          key = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
          value = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).flatMap(_.as[_root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]])
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.javaDescriptor.getNestedTypes().get(2)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.scalaDescriptor.nestedMessages(2)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = {
      var __out: _root_.scalapb.GeneratedMessageCompanion[?] = null
      (__number: @_root_.scala.unchecked) match {
        case 2 => __out = pulumirpc.resource.RegisterResourceRequest.PropertyDependencies
      }
      __out
    }
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry(
      key = "",
      value = _root_.scala.None
    )
    implicit class PropertyDependenciesEntryLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry](_l) {
      def key: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.key)((c_, f_) => c_.copy(key = f_))
      def value: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies] = field(_.getValue)((c_, f_) => c_.copy(value = _root_.scala.Option(f_)))
      def optionalValue: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]] = field(_.value)((c_, f_) => c_.copy(value = f_))
    }
    final val KEY_FIELD_NUMBER = 1
    final val VALUE_FIELD_NUMBER = 2
    @transient
    implicit val keyValueMapper: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry, (_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies)] =
      _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry, (_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies)](__m => (__m.key, __m.getValue))(__p => pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry(__p._1, Some(__p._2)))
    def of(
      key: _root_.scala.Predef.String,
      value: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]
    ): _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry = _root_.pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry(
      key,
      value
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest.PropertyDependenciesEntry])
  }
  
  @SerialVersionUID(0L)
  final case class ProvidersEntry(
      key: _root_.scala.Predef.String = "",
      value: _root_.scala.Predef.String = "",
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[ProvidersEntry] {
      @transient
      private var __serializedSizeMemoized: _root_.scala.Int = 0
      private def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        
        {
          val __value = key
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
          }
        };
        
        {
          val __value = value
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(2, __value)
          }
        };
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        {
          val __v = key
          if (!__v.isEmpty) {
            _output__.writeString(1, __v)
          }
        };
        {
          val __v = value
          if (!__v.isEmpty) {
            _output__.writeString(2, __v)
          }
        };
        unknownFields.writeTo(_output__)
      }
      def withKey(__v: _root_.scala.Predef.String): ProvidersEntry = copy(key = __v)
      def withValue(__v: _root_.scala.Predef.String): ProvidersEntry = copy(value = __v)
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => {
            val __t = key
            if (__t != "") __t else null
          }
          case 2 => {
            val __t = value
            if (__t != "") __t else null
          }
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => _root_.scalapb.descriptors.PString(key)
          case 2 => _root_.scalapb.descriptors.PString(value)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: pulumirpc.resource.RegisterResourceRequest.ProvidersEntry.type = pulumirpc.resource.RegisterResourceRequest.ProvidersEntry
      // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest.ProvidersEntry])
  }
  
  object ProvidersEntry extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry] = this
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest.ProvidersEntry = {
      var __key: _root_.scala.Predef.String = ""
      var __value: _root_.scala.Predef.String = ""
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __key = _input__.readStringRequireUtf8()
          case 18 =>
            __value = _input__.readStringRequireUtf8()
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            _unknownFields__.parseField(tag, _input__)
        }
      }
      pulumirpc.resource.RegisterResourceRequest.ProvidersEntry(
          key = __key,
          value = __value,
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        pulumirpc.resource.RegisterResourceRequest.ProvidersEntry(
          key = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
          value = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).map(_.as[_root_.scala.Predef.String]).getOrElse("")
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.javaDescriptor.getNestedTypes().get(3)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.scalaDescriptor.nestedMessages(3)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = throw new MatchError(__number)
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest.ProvidersEntry(
      key = "",
      value = ""
    )
    implicit class ProvidersEntryLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.ProvidersEntry]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest.ProvidersEntry](_l) {
      def key: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.key)((c_, f_) => c_.copy(key = f_))
      def value: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.value)((c_, f_) => c_.copy(value = f_))
    }
    final val KEY_FIELD_NUMBER = 1
    final val VALUE_FIELD_NUMBER = 2
    @transient
    implicit val keyValueMapper: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry, (_root_.scala.Predef.String, _root_.scala.Predef.String)] =
      _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry, (_root_.scala.Predef.String, _root_.scala.Predef.String)](__m => (__m.key, __m.value))(__p => pulumirpc.resource.RegisterResourceRequest.ProvidersEntry(__p._1, __p._2))
    def of(
      key: _root_.scala.Predef.String,
      value: _root_.scala.Predef.String
    ): _root_.pulumirpc.resource.RegisterResourceRequest.ProvidersEntry = _root_.pulumirpc.resource.RegisterResourceRequest.ProvidersEntry(
      key,
      value
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest.ProvidersEntry])
  }
  
  @SerialVersionUID(0L)
  final case class PluginChecksumsEntry(
      key: _root_.scala.Predef.String = "",
      value: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY,
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[PluginChecksumsEntry] {
      @transient
      private var __serializedSizeMemoized: _root_.scala.Int = 0
      private def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        
        {
          val __value = key
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
          }
        };
        
        {
          val __value = value
          if (!__value.isEmpty) {
            __size += _root_.com.google.protobuf.CodedOutputStream.computeBytesSize(2, __value)
          }
        };
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        {
          val __v = key
          if (!__v.isEmpty) {
            _output__.writeString(1, __v)
          }
        };
        {
          val __v = value
          if (!__v.isEmpty) {
            _output__.writeBytes(2, __v)
          }
        };
        unknownFields.writeTo(_output__)
      }
      def withKey(__v: _root_.scala.Predef.String): PluginChecksumsEntry = copy(key = __v)
      def withValue(__v: _root_.com.google.protobuf.ByteString): PluginChecksumsEntry = copy(value = __v)
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => {
            val __t = key
            if (__t != "") __t else null
          }
          case 2 => {
            val __t = value
            if (__t != _root_.com.google.protobuf.ByteString.EMPTY) __t else null
          }
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => _root_.scalapb.descriptors.PString(key)
          case 2 => _root_.scalapb.descriptors.PByteString(value)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry.type = pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry
      // @@protoc_insertion_point(GeneratedMessage[pulumirpc.RegisterResourceRequest.PluginChecksumsEntry])
  }
  
  object PluginChecksumsEntry extends scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry] = this
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry = {
      var __key: _root_.scala.Predef.String = ""
      var __value: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __key = _input__.readStringRequireUtf8()
          case 18 =>
            __value = _input__.readBytes()
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            _unknownFields__.parseField(tag, _input__)
        }
      }
      pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry(
          key = __key,
          value = __value,
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry(
          key = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).map(_.as[_root_.scala.Predef.String]).getOrElse(""),
          value = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).map(_.as[_root_.com.google.protobuf.ByteString]).getOrElse(_root_.com.google.protobuf.ByteString.EMPTY)
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.javaDescriptor.getNestedTypes().get(4)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = pulumirpc.resource.RegisterResourceRequest.scalaDescriptor.nestedMessages(4)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[?] = throw new MatchError(__number)
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[? <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[?] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry(
      key = "",
      value = _root_.com.google.protobuf.ByteString.EMPTY
    )
    implicit class PluginChecksumsEntryLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry](_l) {
      def key: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.key)((c_, f_) => c_.copy(key = f_))
      def value: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.ByteString] = field(_.value)((c_, f_) => c_.copy(value = f_))
    }
    final val KEY_FIELD_NUMBER = 1
    final val VALUE_FIELD_NUMBER = 2
    @transient
    implicit val keyValueMapper: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry, (_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString)] =
      _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry, (_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString)](__m => (__m.key, __m.value))(__p => pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry(__p._1, __p._2))
    def of(
      key: _root_.scala.Predef.String,
      value: _root_.com.google.protobuf.ByteString
    ): _root_.pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry = _root_.pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry(
      key,
      value
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest.PluginChecksumsEntry])
  }
  
  implicit class RegisterResourceRequestLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest]) extends _root_.scalapb.lenses.MessageLens[UpperPB, pulumirpc.resource.RegisterResourceRequest](_l) {
    def `type`: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.`type`)((c_, f_) => c_.copy(`type` = f_))
    def name: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.name)((c_, f_) => c_.copy(name = f_))
    def parent: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.parent)((c_, f_) => c_.copy(parent = f_))
    def custom: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.custom)((c_, f_) => c_.copy(custom = f_))
    def `object`: _root_.scalapb.lenses.Lens[UpperPB, com.google.protobuf.struct.Struct] = field(_.getObject)((c_, f_) => c_.copy(`object` = _root_.scala.Option(f_)))
    def optionalObject: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[com.google.protobuf.struct.Struct]] = field(_.`object`)((c_, f_) => c_.copy(`object` = f_))
    def protect: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.protect)((c_, f_) => c_.copy(protect = f_))
    def dependencies: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.dependencies)((c_, f_) => c_.copy(dependencies = f_))
    def provider: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.provider)((c_, f_) => c_.copy(provider = f_))
    def propertyDependencies: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies]] = field(_.propertyDependencies)((c_, f_) => c_.copy(propertyDependencies = f_))
    def deleteBeforeReplace: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.deleteBeforeReplace)((c_, f_) => c_.copy(deleteBeforeReplace = f_))
    def version: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.version)((c_, f_) => c_.copy(version = f_))
    def ignoreChanges: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.ignoreChanges)((c_, f_) => c_.copy(ignoreChanges = f_))
    def acceptSecrets: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.acceptSecrets)((c_, f_) => c_.copy(acceptSecrets = f_))
    def additionalSecretOutputs: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.additionalSecretOutputs)((c_, f_) => c_.copy(additionalSecretOutputs = f_))
    def aliasURNs: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.aliasURNs)((c_, f_) => c_.copy(aliasURNs = f_))
    def importId: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.importId)((c_, f_) => c_.copy(importId = f_))
    def customTimeouts: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.resource.RegisterResourceRequest.CustomTimeouts] = field(_.getCustomTimeouts)((c_, f_) => c_.copy(customTimeouts = _root_.scala.Option(f_)))
    def optionalCustomTimeouts: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts]] = field(_.customTimeouts)((c_, f_) => c_.copy(customTimeouts = f_))
    def deleteBeforeReplaceDefined: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.deleteBeforeReplaceDefined)((c_, f_) => c_.copy(deleteBeforeReplaceDefined = f_))
    def supportsPartialValues: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.supportsPartialValues)((c_, f_) => c_.copy(supportsPartialValues = f_))
    def remote: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.remote)((c_, f_) => c_.copy(remote = f_))
    def acceptResources: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.acceptResources)((c_, f_) => c_.copy(acceptResources = f_))
    def providers: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.scala.Predef.String]] = field(_.providers)((c_, f_) => c_.copy(providers = f_))
    def replaceOnChanges: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.scala.Predef.String]] = field(_.replaceOnChanges)((c_, f_) => c_.copy(replaceOnChanges = f_))
    def pluginDownloadURL: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.pluginDownloadURL)((c_, f_) => c_.copy(pluginDownloadURL = f_))
    def pluginChecksums: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString]] = field(_.pluginChecksums)((c_, f_) => c_.copy(pluginChecksums = f_))
    def retainOnDelete: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.retainOnDelete)((c_, f_) => c_.copy(retainOnDelete = f_))
    def aliases: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[pulumirpc.alias.Alias]] = field(_.aliases)((c_, f_) => c_.copy(aliases = f_))
    def deletedWith: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.deletedWith)((c_, f_) => c_.copy(deletedWith = f_))
    def aliasSpecs: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.aliasSpecs)((c_, f_) => c_.copy(aliasSpecs = f_))
    def sourcePosition: _root_.scalapb.lenses.Lens[UpperPB, pulumirpc.source.SourcePosition] = field(_.getSourcePosition)((c_, f_) => c_.copy(sourcePosition = _root_.scala.Option(f_)))
    def optionalSourcePosition: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[pulumirpc.source.SourcePosition]] = field(_.sourcePosition)((c_, f_) => c_.copy(sourcePosition = f_))
    def transforms: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[pulumirpc.callback.Callback]] = field(_.transforms)((c_, f_) => c_.copy(transforms = f_))
    def supportsResultReporting: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Boolean] = field(_.supportsResultReporting)((c_, f_) => c_.copy(supportsResultReporting = f_))
    def packageRef: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.packageRef)((c_, f_) => c_.copy(packageRef = f_))
  }
  final val TYPE_FIELD_NUMBER = 1
  final val NAME_FIELD_NUMBER = 2
  final val PARENT_FIELD_NUMBER = 3
  final val CUSTOM_FIELD_NUMBER = 4
  final val OBJECT_FIELD_NUMBER = 5
  final val PROTECT_FIELD_NUMBER = 6
  final val DEPENDENCIES_FIELD_NUMBER = 7
  final val PROVIDER_FIELD_NUMBER = 8
  final val PROPERTYDEPENDENCIES_FIELD_NUMBER = 9
  final val DELETEBEFOREREPLACE_FIELD_NUMBER = 10
  final val VERSION_FIELD_NUMBER = 11
  final val IGNORECHANGES_FIELD_NUMBER = 12
  final val ACCEPTSECRETS_FIELD_NUMBER = 13
  final val ADDITIONALSECRETOUTPUTS_FIELD_NUMBER = 14
  final val ALIASURNS_FIELD_NUMBER = 15
  final val IMPORTID_FIELD_NUMBER = 16
  final val CUSTOMTIMEOUTS_FIELD_NUMBER = 17
  final val DELETEBEFOREREPLACEDEFINED_FIELD_NUMBER = 18
  final val SUPPORTSPARTIALVALUES_FIELD_NUMBER = 19
  final val REMOTE_FIELD_NUMBER = 20
  final val ACCEPTRESOURCES_FIELD_NUMBER = 21
  final val PROVIDERS_FIELD_NUMBER = 22
  final val REPLACEONCHANGES_FIELD_NUMBER = 23
  final val PLUGINDOWNLOADURL_FIELD_NUMBER = 24
  final val PLUGINCHECKSUMS_FIELD_NUMBER = 30
  final val RETAINONDELETE_FIELD_NUMBER = 25
  final val ALIASES_FIELD_NUMBER = 26
  final val DELETEDWITH_FIELD_NUMBER = 27
  final val ALIASSPECS_FIELD_NUMBER = 28
  final val SOURCEPOSITION_FIELD_NUMBER = 29
  final val TRANSFORMS_FIELD_NUMBER = 31
  final val SUPPORTSRESULTREPORTING_FIELD_NUMBER = 32
  final val PACKAGEREF_FIELD_NUMBER = 33
  @transient
  private[resource] val _typemapper_propertyDependencies: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry, (_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies)] = implicitly[_root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PropertyDependenciesEntry, (_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies)]]
  @transient
  private[resource] val _typemapper_providers: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry, (_root_.scala.Predef.String, _root_.scala.Predef.String)] = implicitly[_root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.ProvidersEntry, (_root_.scala.Predef.String, _root_.scala.Predef.String)]]
  @transient
  private[resource] val _typemapper_pluginChecksums: _root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry, (_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString)] = implicitly[_root_.scalapb.TypeMapper[pulumirpc.resource.RegisterResourceRequest.PluginChecksumsEntry, (_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString)]]
  def of(
    `type`: _root_.scala.Predef.String,
    name: _root_.scala.Predef.String,
    parent: _root_.scala.Predef.String,
    custom: _root_.scala.Boolean,
    `object`: _root_.scala.Option[com.google.protobuf.struct.Struct],
    protect: _root_.scala.Boolean,
    dependencies: _root_.scala.Seq[_root_.scala.Predef.String],
    provider: _root_.scala.Predef.String,
    propertyDependencies: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, pulumirpc.resource.RegisterResourceRequest.PropertyDependencies],
    deleteBeforeReplace: _root_.scala.Boolean,
    version: _root_.scala.Predef.String,
    ignoreChanges: _root_.scala.Seq[_root_.scala.Predef.String],
    acceptSecrets: _root_.scala.Boolean,
    additionalSecretOutputs: _root_.scala.Seq[_root_.scala.Predef.String],
    aliasURNs: _root_.scala.Seq[_root_.scala.Predef.String],
    importId: _root_.scala.Predef.String,
    customTimeouts: _root_.scala.Option[pulumirpc.resource.RegisterResourceRequest.CustomTimeouts],
    deleteBeforeReplaceDefined: _root_.scala.Boolean,
    supportsPartialValues: _root_.scala.Boolean,
    remote: _root_.scala.Boolean,
    acceptResources: _root_.scala.Boolean,
    providers: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.scala.Predef.String],
    replaceOnChanges: _root_.scala.Seq[_root_.scala.Predef.String],
    pluginDownloadURL: _root_.scala.Predef.String,
    pluginChecksums: _root_.scala.collection.immutable.Map[_root_.scala.Predef.String, _root_.com.google.protobuf.ByteString],
    retainOnDelete: _root_.scala.Boolean,
    aliases: _root_.scala.Seq[pulumirpc.alias.Alias],
    deletedWith: _root_.scala.Predef.String,
    aliasSpecs: _root_.scala.Boolean,
    sourcePosition: _root_.scala.Option[pulumirpc.source.SourcePosition],
    transforms: _root_.scala.Seq[pulumirpc.callback.Callback],
    supportsResultReporting: _root_.scala.Boolean,
    packageRef: _root_.scala.Predef.String
  ): _root_.pulumirpc.resource.RegisterResourceRequest = _root_.pulumirpc.resource.RegisterResourceRequest(
    `type`,
    name,
    parent,
    custom,
    `object`,
    protect,
    dependencies,
    provider,
    propertyDependencies,
    deleteBeforeReplace,
    version,
    ignoreChanges,
    acceptSecrets,
    additionalSecretOutputs,
    aliasURNs,
    importId,
    customTimeouts,
    deleteBeforeReplaceDefined,
    supportsPartialValues,
    remote,
    acceptResources,
    providers,
    replaceOnChanges,
    pluginDownloadURL,
    pluginChecksums,
    retainOnDelete,
    aliases,
    deletedWith,
    aliasSpecs,
    sourcePosition,
    transforms,
    supportsResultReporting,
    packageRef
  )
  // @@protoc_insertion_point(GeneratedMessageCompanion[pulumirpc.RegisterResourceRequest])
}
