package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Offset private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  baseRfc3339: Output[String],
  day: Output[Int],
  hour: Output[Int],
  minute: Output[Int],
  month: Output[Int],
  offsetDays: Output[Option[Int]],
  offsetHours: Output[Option[Int]],
  offsetMinutes: Output[Option[Int]],
  offsetMonths: Output[Option[Int]],
  offsetSeconds: Output[Option[Int]],
  offsetYears: Output[Option[Int]],
  rfc3339: Output[String],
  second: Output[Int],
  triggers: Output[Option[scala.Predef.Map[String, String]]],
  unix: Output[Int],
  year: Output[Int]
) extends CustomResource derives ResourceDecoder

object Offset:
  given outputOps: {} with
    extension(output: Output[Offset])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def baseRfc3339: Output[String] = output.flatMap(_.baseRfc3339)
      def day: Output[Int] = output.flatMap(_.day)
      def hour: Output[Int] = output.flatMap(_.hour)
      def minute: Output[Int] = output.flatMap(_.minute)
      def month: Output[Int] = output.flatMap(_.month)
      def offsetDays: Output[Option[Int]] = output.flatMap(_.offsetDays)
      def offsetHours: Output[Option[Int]] = output.flatMap(_.offsetHours)
      def offsetMinutes: Output[Option[Int]] = output.flatMap(_.offsetMinutes)
      def offsetMonths: Output[Option[Int]] = output.flatMap(_.offsetMonths)
      def offsetSeconds: Output[Option[Int]] = output.flatMap(_.offsetSeconds)
      def offsetYears: Output[Option[Int]] = output.flatMap(_.offsetYears)
      def rfc3339: Output[String] = output.flatMap(_.rfc3339)
      def second: Output[Int] = output.flatMap(_.second)
      def triggers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.triggers)
      def unix: Output[Int] = output.flatMap(_.unix)
      def year: Output[Int] = output.flatMap(_.year)

def offset(using ctx: Context)(
  name: NonEmptyString,
  args: OffsetArgs = OffsetArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Offset] = 
  ctx.registerResource[Offset, OffsetArgs]("time:index/offset:Offset", name, args, opts)

