package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OffsetArgs private(
  baseRfc3339: Output[Option[String]],
  offsetDays: Output[Option[Int]],
  offsetHours: Output[Option[Int]],
  offsetMinutes: Output[Option[Int]],
  offsetMonths: Output[Option[Int]],
  offsetSeconds: Output[Option[Int]],
  offsetYears: Output[Option[Int]],
  triggers: Output[Option[scala.Predef.Map[String, String]]]
) derives ArgsEncoder

object OffsetArgs:
  def apply(
    baseRfc3339: Input.Optional[String] = None,
    offsetDays: Input.Optional[Int] = None,
    offsetHours: Input.Optional[Int] = None,
    offsetMinutes: Input.Optional[Int] = None,
    offsetMonths: Input.Optional[Int] = None,
    offsetSeconds: Input.Optional[Int] = None,
    offsetYears: Input.Optional[Int] = None,
    triggers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None
  )(using Context): OffsetArgs =
    new OffsetArgs(
      baseRfc3339 = baseRfc3339.asOptionOutput(isSecret = false),
      offsetDays = offsetDays.asOptionOutput(isSecret = false),
      offsetHours = offsetHours.asOptionOutput(isSecret = false),
      offsetMinutes = offsetMinutes.asOptionOutput(isSecret = false),
      offsetMonths = offsetMonths.asOptionOutput(isSecret = false),
      offsetSeconds = offsetSeconds.asOptionOutput(isSecret = false),
      offsetYears = offsetYears.asOptionOutput(isSecret = false),
      triggers = triggers.asOptionOutput(isSecret = false)
    )
