package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Rotating private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  day: Output[Int],
  hour: Output[Int],
  minute: Output[Int],
  month: Output[Int],
  rfc3339: Output[String],
  rotationDays: Output[Option[Int]],
  rotationHours: Output[Option[Int]],
  rotationMinutes: Output[Option[Int]],
  rotationMonths: Output[Option[Int]],
  rotationRfc3339: Output[String],
  rotationYears: Output[Option[Int]],
  second: Output[Int],
  triggers: Output[Option[scala.Predef.Map[String, String]]],
  unix: Output[Int],
  year: Output[Int]
) extends CustomResource derives ResourceDecoder

object Rotating:
  given outputOps: {} with
    extension(output: Output[Rotating])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def day: Output[Int] = output.flatMap(_.day)
      def hour: Output[Int] = output.flatMap(_.hour)
      def minute: Output[Int] = output.flatMap(_.minute)
      def month: Output[Int] = output.flatMap(_.month)
      def rfc3339: Output[String] = output.flatMap(_.rfc3339)
      def rotationDays: Output[Option[Int]] = output.flatMap(_.rotationDays)
      def rotationHours: Output[Option[Int]] = output.flatMap(_.rotationHours)
      def rotationMinutes: Output[Option[Int]] = output.flatMap(_.rotationMinutes)
      def rotationMonths: Output[Option[Int]] = output.flatMap(_.rotationMonths)
      def rotationRfc3339: Output[String] = output.flatMap(_.rotationRfc3339)
      def rotationYears: Output[Option[Int]] = output.flatMap(_.rotationYears)
      def second: Output[Int] = output.flatMap(_.second)
      def triggers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.triggers)
      def unix: Output[Int] = output.flatMap(_.unix)
      def year: Output[Int] = output.flatMap(_.year)

def rotating(using ctx: Context)(
  name: NonEmptyString,
  args: RotatingArgs = RotatingArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Rotating] = 
  ctx.registerResource[Rotating, RotatingArgs]("time:index/rotating:Rotating", name, args, opts)

