package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RotatingArgs private(
  rfc3339: Output[Option[String]],
  rotationDays: Output[Option[Int]],
  rotationHours: Output[Option[Int]],
  rotationMinutes: Output[Option[Int]],
  rotationMonths: Output[Option[Int]],
  rotationRfc3339: Output[Option[String]],
  rotationYears: Output[Option[Int]],
  triggers: Output[Option[scala.Predef.Map[String, String]]]
) derives ArgsEncoder

object RotatingArgs:
  def apply(
    rfc3339: Input.Optional[String] = None,
    rotationDays: Input.Optional[Int] = None,
    rotationHours: Input.Optional[Int] = None,
    rotationMinutes: Input.Optional[Int] = None,
    rotationMonths: Input.Optional[Int] = None,
    rotationRfc3339: Input.Optional[String] = None,
    rotationYears: Input.Optional[Int] = None,
    triggers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None
  )(using Context): RotatingArgs =
    new RotatingArgs(
      rfc3339 = rfc3339.asOptionOutput(isSecret = false),
      rotationDays = rotationDays.asOptionOutput(isSecret = false),
      rotationHours = rotationHours.asOptionOutput(isSecret = false),
      rotationMinutes = rotationMinutes.asOptionOutput(isSecret = false),
      rotationMonths = rotationMonths.asOptionOutput(isSecret = false),
      rotationRfc3339 = rotationRfc3339.asOptionOutput(isSecret = false),
      rotationYears = rotationYears.asOptionOutput(isSecret = false),
      triggers = triggers.asOptionOutput(isSecret = false)
    )
