package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Static private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  day: Output[Int],
  hour: Output[Int],
  minute: Output[Int],
  month: Output[Int],
  rfc3339: Output[String],
  second: Output[Int],
  triggers: Output[Option[scala.Predef.Map[String, String]]],
  unix: Output[Int],
  year: Output[Int]
) extends CustomResource derives ResourceDecoder

object Static:
  given outputOps: {} with
    extension(output: Output[Static])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def day: Output[Int] = output.flatMap(_.day)
      def hour: Output[Int] = output.flatMap(_.hour)
      def minute: Output[Int] = output.flatMap(_.minute)
      def month: Output[Int] = output.flatMap(_.month)
      def rfc3339: Output[String] = output.flatMap(_.rfc3339)
      def second: Output[Int] = output.flatMap(_.second)
      def triggers: Output[Option[scala.Predef.Map[String, String]]] = output.flatMap(_.triggers)
      def unix: Output[Int] = output.flatMap(_.unix)
      def year: Output[Int] = output.flatMap(_.year)

def static(using ctx: Context)(
  name: NonEmptyString,
  args: StaticArgs = StaticArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Static] = 
  ctx.registerResource[Static, StaticArgs]("time:index/static:Static", name, args, opts)

