package besom.api.time

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class StaticArgs private(
  rfc3339: Output[Option[String]],
  triggers: Output[Option[scala.Predef.Map[String, String]]]
) derives ArgsEncoder

object StaticArgs:
  def apply(
    rfc3339: Input.Optional[String] = None,
    triggers: Input.Optional[scala.Predef.Map[String, Input[String]]] = None
  )(using Context): StaticArgs =
    new StaticArgs(
      rfc3339 = rfc3339.asOptionOutput(isSecret = false),
      triggers = triggers.asOptionOutput(isSecret = false)
    )
