/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.inkuire.engine.api;

import java.io.Serializable;
import org.virtuslab.inkuire.engine.api.BaseMatchQualityService;
import org.virtuslab.inkuire.engine.api.BaseMatchService;
import org.virtuslab.inkuire.engine.api.BaseSignatureParserService;
import org.virtuslab.inkuire.engine.api.BaseSignaturePrettifier;
import org.virtuslab.inkuire.engine.api.BaseSignatureResolver;
import org.virtuslab.inkuire.engine.api.InkuireDb;
import org.virtuslab.inkuire.engine.api.InkuireEnv$;
import org.virtuslab.inkuire.engine.impl.model.AnnotatedSignature;
import org.virtuslab.inkuire.engine.impl.model.ParsedSignature;
import org.virtuslab.inkuire.engine.impl.model.ResolveResult;
import org.virtuslab.inkuire.engine.impl.model.Signature;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class InkuireEnv
implements Product,
Serializable {
    private final InkuireDb db;
    private final BaseSignatureParserService parser;
    private final BaseSignatureResolver resolver;
    private final BaseMatchService matcher;
    private final BaseMatchQualityService matchQualityService;
    private final BaseSignaturePrettifier prettifier;

    public static InkuireEnv apply(InkuireDb inkuireDb, BaseSignatureParserService baseSignatureParserService, BaseSignatureResolver baseSignatureResolver, BaseMatchService baseMatchService, BaseMatchQualityService baseMatchQualityService, BaseSignaturePrettifier baseSignaturePrettifier) {
        return InkuireEnv$.MODULE$.apply(inkuireDb, baseSignatureParserService, baseSignatureResolver, baseMatchService, baseMatchQualityService, baseSignaturePrettifier);
    }

    public static Function1<InkuireDb, InkuireEnv> defaultScalaEnv(BaseSignatureParserService baseSignatureParserService, Function1<InkuireDb, BaseSignatureResolver> function1, Function1<InkuireDb, BaseMatchService> function12, Function1<InkuireDb, BaseMatchQualityService> function13, BaseSignaturePrettifier baseSignaturePrettifier) {
        return InkuireEnv$.MODULE$.defaultScalaEnv(baseSignatureParserService, function1, function12, function13, baseSignaturePrettifier);
    }

    public static InkuireEnv fromProduct(Product product) {
        return InkuireEnv$.MODULE$.fromProduct(product);
    }

    public static InkuireEnv unapply(InkuireEnv inkuireEnv) {
        return InkuireEnv$.MODULE$.unapply(inkuireEnv);
    }

    public static BaseSignatureParserService defaultScalaEnv$default$1() {
        return InkuireEnv$.MODULE$.defaultScalaEnv$default$1();
    }

    public static Function1<InkuireDb, BaseSignatureResolver> defaultScalaEnv$default$2() {
        return InkuireEnv$.MODULE$.defaultScalaEnv$default$2();
    }

    public static Function1<InkuireDb, BaseMatchService> defaultScalaEnv$default$3() {
        return InkuireEnv$.MODULE$.defaultScalaEnv$default$3();
    }

    public static Function1<InkuireDb, BaseMatchQualityService> defaultScalaEnv$default$4() {
        return InkuireEnv$.MODULE$.defaultScalaEnv$default$4();
    }

    public static BaseSignaturePrettifier defaultScalaEnv$default$5() {
        return InkuireEnv$.MODULE$.defaultScalaEnv$default$5();
    }

    public InkuireEnv(InkuireDb db, BaseSignatureParserService parser, BaseSignatureResolver resolver, BaseMatchService matcher, BaseMatchQualityService matchQualityService, BaseSignaturePrettifier prettifier) {
        this.db = db;
        this.parser = parser;
        this.resolver = resolver;
        this.matcher = matcher;
        this.matchQualityService = matchQualityService;
        this.prettifier = prettifier;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof InkuireEnv)) return false;
        InkuireEnv inkuireEnv = (InkuireEnv)object;
        InkuireDb inkuireDb = this.db();
        InkuireDb inkuireDb2 = inkuireEnv.db();
        if (inkuireDb == null) {
            if (inkuireDb2 != null) {
                return false;
            }
        } else if (!((Object)inkuireDb).equals(inkuireDb2)) return false;
        BaseSignatureParserService baseSignatureParserService = this.parser();
        BaseSignatureParserService baseSignatureParserService2 = inkuireEnv.parser();
        if (baseSignatureParserService == null) {
            if (baseSignatureParserService2 != null) {
                return false;
            }
        } else if (!baseSignatureParserService.equals(baseSignatureParserService2)) return false;
        BaseSignatureResolver baseSignatureResolver = this.resolver();
        BaseSignatureResolver baseSignatureResolver2 = inkuireEnv.resolver();
        if (baseSignatureResolver == null) {
            if (baseSignatureResolver2 != null) {
                return false;
            }
        } else if (!baseSignatureResolver.equals(baseSignatureResolver2)) return false;
        BaseMatchService baseMatchService = this.matcher();
        BaseMatchService baseMatchService2 = inkuireEnv.matcher();
        if (baseMatchService == null) {
            if (baseMatchService2 != null) {
                return false;
            }
        } else if (!baseMatchService.equals(baseMatchService2)) return false;
        BaseMatchQualityService baseMatchQualityService = this.matchQualityService();
        BaseMatchQualityService baseMatchQualityService2 = inkuireEnv.matchQualityService();
        if (baseMatchQualityService == null) {
            if (baseMatchQualityService2 != null) {
                return false;
            }
        } else if (!baseMatchQualityService.equals(baseMatchQualityService2)) return false;
        BaseSignaturePrettifier baseSignaturePrettifier = this.prettifier();
        BaseSignaturePrettifier baseSignaturePrettifier2 = inkuireEnv.prettifier();
        if (baseSignaturePrettifier == null) {
            if (baseSignaturePrettifier2 != null) {
                return false;
            }
        } else if (!baseSignaturePrettifier.equals(baseSignaturePrettifier2)) return false;
        if (!inkuireEnv.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof InkuireEnv;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "InkuireEnv";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "db";
                break;
            }
            case 1: {
                string = "parser";
                break;
            }
            case 2: {
                string = "resolver";
                break;
            }
            case 3: {
                string = "matcher";
                break;
            }
            case 4: {
                string = "matchQualityService";
                break;
            }
            case 5: {
                string = "prettifier";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public InkuireDb db() {
        return this.db;
    }

    public BaseSignatureParserService parser() {
        return this.parser;
    }

    public BaseSignatureResolver resolver() {
        return this.resolver;
    }

    public BaseMatchService matcher() {
        return this.matcher;
    }

    public BaseMatchQualityService matchQualityService() {
        return this.matchQualityService;
    }

    public BaseSignaturePrettifier prettifier() {
        return this.prettifier;
    }

    public Either<String, Seq<AnnotatedSignature>> query(String signature) {
        return this.queryRaw(signature).map((Function1 & Serializable)_$1 -> (Seq)_$1.map((Function1 & Serializable)_$2 -> (AnnotatedSignature)_$2._1()));
    }

    public String prettify(AnnotatedSignature signature) {
        return this.prettifier().prettify(signature);
    }

    public Either<String, Seq<Tuple2<AnnotatedSignature, Object>>> queryRaw(String signature) {
        return this.parser().parse(signature).flatMap((Function1 & Serializable)parsed -> this.resolver().resolve((ParsedSignature)parsed)).map((Function1 & Serializable)resolveResult -> this.matcher().findMatches((ResolveResult)resolveResult)).map((Function1 & Serializable)functions -> this.matchQualityService().sortMatches((Seq<Tuple2<AnnotatedSignature, Signature>>)functions));
    }

    public InkuireEnv copy(InkuireDb db, BaseSignatureParserService parser, BaseSignatureResolver resolver, BaseMatchService matcher, BaseMatchQualityService matchQualityService, BaseSignaturePrettifier prettifier) {
        return new InkuireEnv(db, parser, resolver, matcher, matchQualityService, prettifier);
    }

    public InkuireDb copy$default$1() {
        return this.db();
    }

    public BaseSignatureParserService copy$default$2() {
        return this.parser();
    }

    public BaseSignatureResolver copy$default$3() {
        return this.resolver();
    }

    public BaseMatchService copy$default$4() {
        return this.matcher();
    }

    public BaseMatchQualityService copy$default$5() {
        return this.matchQualityService();
    }

    public BaseSignaturePrettifier copy$default$6() {
        return this.prettifier();
    }

    public InkuireDb _1() {
        return this.db();
    }

    public BaseSignatureParserService _2() {
        return this.parser();
    }

    public BaseSignatureResolver _3() {
        return this.resolver();
    }

    public BaseMatchService _4() {
        return this.matcher();
    }

    public BaseMatchQualityService _5() {
        return this.matchQualityService();
    }

    public BaseSignaturePrettifier _6() {
        return this.prettifier();
    }
}

