/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.inkuire.engine.impl.service;

import java.io.Serializable;
import org.virtuslab.inkuire.engine.api.BaseSignaturePrettifier;
import org.virtuslab.inkuire.engine.impl.model.AndType;
import org.virtuslab.inkuire.engine.impl.model.AndType$;
import org.virtuslab.inkuire.engine.impl.model.AnnotatedSignature;
import org.virtuslab.inkuire.engine.impl.model.OrType;
import org.virtuslab.inkuire.engine.impl.model.OrType$;
import org.virtuslab.inkuire.engine.impl.model.Signature;
import org.virtuslab.inkuire.engine.impl.model.SignatureContext;
import org.virtuslab.inkuire.engine.impl.model.Type;
import org.virtuslab.inkuire.engine.impl.model.TypeLike;
import org.virtuslab.inkuire.engine.impl.model.Variance;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public class KotlinAnnotatedSignaturePrettifier
implements BaseSignaturePrettifier {
    @Override
    public String prettifyAll(Seq<AnnotatedSignature> sgns) {
        return ((IterableOnceOps)((IterableOps)sgns.map((Function1 & Serializable)esgn -> this.prettify((AnnotatedSignature)esgn))).map((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x))).mkString("\n");
    }

    @Override
    public String prettify(AnnotatedSignature esgn) {
        return String.valueOf(this.prettifySignature(esgn.signature()));
    }

    private String prettifySignature(Signature sgn) {
        return new StringBuilder(0).append(this.prettifyTypeVariables(sgn.context())).append(new StringBuilder(6).append(this.prettifyReceiver(sgn.receiver())).append("(").append(this.prettifyArgs(sgn.arguments())).append(") -> ").append(this.prettifyType(sgn.result().typ())).toString()).append(String.valueOf(this.prettifyTypeVariableConstraints(sgn.context()))).toString();
    }

    private String prettifyTypeVariables(SignatureContext context) {
        return context.vars().isEmpty() ? "" : new StringBuilder(3).append("<").append(context.vars().mkString(", ")).append("> ").toString();
    }

    private String prettifyTypeVariableConstraints(SignatureContext context) {
        String string;
        if (context.constraints().isEmpty() || ((IterableOnceOps)context.constraints().values().flatten(Predef$.MODULE$.$conforms())).isEmpty()) {
            string = "";
        } else {
            Iterable constraints = (Iterable)context.constraints().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                Seq value = (Seq)tuple2._2();
                return (Seq)value.map((Function1 & Serializable)v -> new StringBuilder(2).append(key).append(": ").append(this.prettifyType((TypeLike)v)).toString());
            });
            string = new StringBuilder(7).append(" where ").append(constraints.mkString(", ")).toString();
        }
        return string;
    }

    private String prettifyReceiver(Option<Variance> receiver) {
        return (String)receiver.fold(KotlinAnnotatedSignaturePrettifier::prettifyReceiver$$anonfun$1, (Function1 & Serializable)v -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.prettifyType(v.typ())), "."));
    }

    private String prettifyArgs(Seq<Variance> args) {
        return ((IterableOnceOps)((IterableOps)args.map((Function1 & Serializable)_$1 -> _$1.typ())).map((Function1 & Serializable)t -> this.prettifyType((TypeLike)t))).mkString(", ");
    }

    private String prettifyType(TypeLike t) {
        String string;
        TypeLike typeLike = t;
        if (typeLike instanceof Type) {
            Type type = (Type)typeLike;
            Type t2 = type;
            if (t2.isStarProjection()) {
                string = "*";
            } else {
                Type t3 = type;
                if (t3.isGeneric() && !t3.isVariable() && t3.name().name().matches("Function.*")) {
                    string = this.prettifyFunction((List<Variance>)t3.params().toList(), t3.nullable());
                } else {
                    Type t4 = type;
                    if (t4.isGeneric()) {
                        string = new StringBuilder(2).append(t4.name()).append("<").append(this.prettifyArgs(t4.params())).append(">").append(t4.nullable() ? "?" : "").toString();
                    } else {
                        Type t5 = type;
                        string = new StringBuilder(0).append(t5.name()).append(t5.nullable() ? "?" : "").toString();
                    }
                }
            }
        } else if (typeLike instanceof AndType) {
            AndType andType = AndType$.MODULE$.unapply((AndType)typeLike);
            TypeLike typeLike2 = andType._1();
            TypeLike typeLike3 = andType._2();
            TypeLike left = typeLike2;
            TypeLike right = typeLike3;
            string = new StringBuilder(5).append("(").append(this.prettifyType(left)).append(" & ").append(this.prettifyType(right)).append(")").toString();
        } else if (typeLike instanceof OrType) {
            OrType orType = OrType$.MODULE$.unapply((OrType)typeLike);
            TypeLike typeLike4 = orType._1();
            TypeLike typeLike5 = orType._2();
            TypeLike left = typeLike4;
            TypeLike right = typeLike5;
            string = new StringBuilder(5).append("(").append(this.prettifyType(left)).append(" | ").append(this.prettifyType(right)).append(")").toString();
        } else {
            string = t.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String prettifyFunction(List<Variance> params, boolean nullable) {
        void var3_3;
        String prettifiedFunction = new StringBuilder(6).append("(").append(this.prettifyArgs((Seq<Variance>)((Seq)params.init()))).append(") -> ").append(this.prettifyType(((Variance)params.last()).typ())).toString();
        return nullable ? new StringBuilder(3).append("(").append(prettifiedFunction).append(")?").toString() : var3_3;
    }

    private static final String prettifyReceiver$$anonfun$1() {
        return "";
    }
}

