/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.inkuire.engine.impl.service;

import java.io.Serializable;
import org.virtuslab.inkuire.engine.api.BaseSignaturePrettifier;
import org.virtuslab.inkuire.engine.impl.model.AndType;
import org.virtuslab.inkuire.engine.impl.model.AndType$;
import org.virtuslab.inkuire.engine.impl.model.AnnotatedSignature;
import org.virtuslab.inkuire.engine.impl.model.ITID;
import org.virtuslab.inkuire.engine.impl.model.OrType;
import org.virtuslab.inkuire.engine.impl.model.OrType$;
import org.virtuslab.inkuire.engine.impl.model.Signature;
import org.virtuslab.inkuire.engine.impl.model.SignatureContext;
import org.virtuslab.inkuire.engine.impl.model.Type;
import org.virtuslab.inkuire.engine.impl.model.TypeLambda;
import org.virtuslab.inkuire.engine.impl.model.TypeLambda$;
import org.virtuslab.inkuire.engine.impl.model.TypeLike;
import org.virtuslab.inkuire.engine.impl.model.Variance;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;

public class ScalaAnnotatedSignaturePrettifier
implements BaseSignaturePrettifier {
    @Override
    public String prettifyAll(Seq<AnnotatedSignature> sgns) {
        return ((IterableOnceOps)sgns.map((Function1 & Serializable)esgn -> this.prettify((AnnotatedSignature)esgn))).mkString("\n");
    }

    @Override
    public String prettify(AnnotatedSignature esgn) {
        return String.valueOf(this.prettifySignature(esgn.signature()));
    }

    public String prettifySignature(Signature sgn) {
        return new StringBuilder(0).append(this.prettifyTypeVariables(sgn.context())).append(String.valueOf(this.prettifyArgs(sgn.typesWithVariances(), " => "))).toString();
    }

    private String prettifyTypeVariables(SignatureContext context) {
        return context.vars().isEmpty() ? "" : new StringBuilder(6).append("[").append(context.vars().mkString(", ")).append("] => ").toString();
    }

    private String prettifyArgs(Seq<Variance> args, String sep) {
        return ((IterableOnceOps)((IterableOps)args.map((Function1 & Serializable)_$1 -> _$1.typ())).map((Function1 & Serializable)t -> this.prettifyType((TypeLike)t))).mkString(sep);
    }

    private String prettifyArgs$default$2() {
        return ", ";
    }

    /*
     * Enabled aggressive block sorting
     */
    public String prettifyType(TypeLike t) {
        SeqOps seqOps;
        String string;
        TypeLike typeLike = t;
        if (typeLike instanceof Type) {
            Type type = (Type)typeLike;
            Type t2 = type;
            if (t2.isStarProjection()) {
                return "*";
            }
            Type t3 = type;
            if (t3.isGeneric() && !t3.isVariable() && t3.name().name().matches("Function.*")) {
                string = new StringBuilder(2).append("(").append(this.prettifyArgs(t3.params(), " => ")).append(")").toString();
                return string;
            }
            Type t4 = type;
            if (t4.isGeneric() && !t4.isVariable() && t4.name().name().matches("Tuple.*")) {
                string = new StringBuilder(2).append("(").append(this.prettifyArgs(t4.params(), this.prettifyArgs$default$2())).append(")").toString();
                return string;
            }
            Type t5 = type;
            if (t5.isGeneric()) {
                string = new StringBuilder(2).append(t5.name()).append("[").append(this.prettifyArgs(t5.params(), this.prettifyArgs$default$2())).append("]").toString();
                return string;
            }
            Type t6 = type;
            string = String.valueOf(t6.name());
            return string;
        }
        if (typeLike instanceof AndType) {
            AndType andType = AndType$.MODULE$.unapply((AndType)typeLike);
            TypeLike typeLike2 = andType._1();
            TypeLike typeLike3 = andType._2();
            TypeLike left = typeLike2;
            TypeLike right = typeLike3;
            string = new StringBuilder(5).append("(").append(this.prettifyType(left)).append(" & ").append(this.prettifyType(right)).append(")").toString();
            return string;
        }
        if (typeLike instanceof OrType) {
            OrType orType = OrType$.MODULE$.unapply((OrType)typeLike);
            TypeLike typeLike4 = orType._1();
            TypeLike typeLike5 = orType._2();
            TypeLike left = typeLike4;
            TypeLike right = typeLike5;
            string = new StringBuilder(5).append("(").append(this.prettifyType(left)).append(" | ").append(this.prettifyType(right)).append(")").toString();
            return string;
        }
        if (!(typeLike instanceof TypeLambda)) throw new MatchError((Object)typeLike);
        TypeLambda typeLambda = TypeLambda$.MODULE$.unapply((TypeLambda)typeLike);
        Seq<Type> seq = typeLambda._1();
        TypeLike typeLike6 = typeLambda._2();
        if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq), 1) == 0) {
            Type res;
            Type type;
            Type arg = type = (Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            if (typeLike6 instanceof Type && (res = (Type)typeLike6).params().size() == 1 && ((Variance)res.params().head()).typ() instanceof Type) {
                Option<ITID> option = ((Type)((Variance)res.params().head()).typ()).itid();
                Option<ITID> option2 = arg.itid();
                if (!(option != null ? !option.equals(option2) : option2 != null)) {
                    string = new StringBuilder(3).append(res.name()).append("[_]").toString();
                    return string;
                }
            }
        }
        Seq<Type> args = seq;
        TypeLike res = typeLike6;
        string = new StringBuilder(7).append("[").append(((IterableOnceOps)args.map((Function1 & Serializable)_$2 -> _$2.name().name())).mkString(", ")).append("] =>> ").append(this.prettifyType(res)).toString();
        return string;
    }
}

