/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.inkuire.engine.impl.service;

import java.io.Serializable;
import org.virtuslab.inkuire.engine.api.BaseMatchQualityService;
import org.virtuslab.inkuire.engine.api.InkuireDb;
import org.virtuslab.inkuire.engine.impl.model.AndType;
import org.virtuslab.inkuire.engine.impl.model.AndType$;
import org.virtuslab.inkuire.engine.impl.model.AnnotatedSignature;
import org.virtuslab.inkuire.engine.impl.model.Contravariance;
import org.virtuslab.inkuire.engine.impl.model.Contravariance$;
import org.virtuslab.inkuire.engine.impl.model.Covariance;
import org.virtuslab.inkuire.engine.impl.model.Covariance$;
import org.virtuslab.inkuire.engine.impl.model.Invariance;
import org.virtuslab.inkuire.engine.impl.model.Invariance$;
import org.virtuslab.inkuire.engine.impl.model.OrType;
import org.virtuslab.inkuire.engine.impl.model.OrType$;
import org.virtuslab.inkuire.engine.impl.model.Signature;
import org.virtuslab.inkuire.engine.impl.model.Type;
import org.virtuslab.inkuire.engine.impl.model.TypeLambda;
import org.virtuslab.inkuire.engine.impl.model.TypeLike;
import org.virtuslab.inkuire.engine.impl.model.TypeName;
import org.virtuslab.inkuire.engine.impl.model.TypeName$;
import org.virtuslab.inkuire.engine.impl.model.Variance;
import org.virtuslab.inkuire.engine.impl.service.MatchingOps;
import org.virtuslab.inkuire.engine.impl.service.ScalaAnnotatedSignaturePrettifier;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class TopLevelMatchQualityService
implements BaseMatchQualityService,
MatchingOps {
    private final InkuireDb db;
    private final Set avoidThose;
    private final ScalaAnnotatedSignaturePrettifier p;

    public TopLevelMatchQualityService(InkuireDb db) {
        this.db = db;
        this.avoidThose = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Any", "Object", "AnyVal", "AnyRef", "Matchable", "Nothing"}))).map((Function1 & Serializable)name -> TypeName$.MODULE$.apply((String)name));
        this.p = new ScalaAnnotatedSignaturePrettifier();
    }

    public InkuireDb db() {
        return this.db;
    }

    @Override
    public int matchQualityMetric(AnnotatedSignature AnnotatedSignature2, Signature matching) {
        return this.variancesMatchQualityMetric(AnnotatedSignature2.signature().typesWithVariances(), matching.typesWithVariances());
    }

    public int variancesMatchQualityMetric(Seq<Variance> typVariances, Seq<Variance> suprVariances) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)typVariances.zip(suprVariances)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Variance v1 = (Variance)tuple2._1();
            Variance v2 = (Variance)tuple2._2();
            return this.varianceMatchQualityMetric(v1, v2);
        })).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int varianceMatchQualityMetric(Variance typVariance, Variance suprVariance) {
        int n;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)typVariance, (Object)suprVariance);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Variance variance = (Variance)tuple2._1();
        Variance variance2 = (Variance)tuple2._2();
        if (variance instanceof Covariance) {
            TypeLike typeLike;
            Covariance covariance = Covariance$.MODULE$.unapply((Covariance)variance);
            TypeLike typParam = typeLike = covariance._1();
            if (variance2 instanceof Covariance) {
                TypeLike typeLike2;
                Covariance covariance2 = Covariance$.MODULE$.unapply((Covariance)variance2);
                TypeLike suprParam = typeLike2 = covariance2._1();
                n = this.typeMatchQualityMetric(typParam, suprParam);
                return n;
            }
        }
        if (variance instanceof Contravariance) {
            TypeLike typeLike;
            Contravariance contravariance = Contravariance$.MODULE$.unapply((Contravariance)variance);
            TypeLike typParam = typeLike = contravariance._1();
            if (variance2 instanceof Contravariance) {
                TypeLike typeLike3;
                Contravariance contravariance2 = Contravariance$.MODULE$.unapply((Contravariance)variance2);
                TypeLike suprParam = typeLike3 = contravariance2._1();
                n = this.typeMatchQualityMetric(suprParam, typParam);
                return n;
            }
        }
        if (variance instanceof Invariance) {
            TypeLike typeLike;
            Invariance invariance = Invariance$.MODULE$.unapply((Invariance)variance);
            TypeLike typParam = typeLike = invariance._1();
            if (variance2 instanceof Invariance) {
                TypeLike typeLike4;
                Invariance invariance2 = Invariance$.MODULE$.unapply((Invariance)variance2);
                TypeLike suprParam = typeLike4 = invariance2._1();
                n = this.typeMatchQualityMetric(typParam, suprParam) + this.typeMatchQualityMetric(suprParam, typParam);
                return n;
            }
        }
        Variance v1 = variance;
        Variance v2 = variance2;
        TypeLike typParam = v1.typ();
        TypeLike suprParam = v2.typ();
        n = this.typeMatchQualityMetric(typParam, suprParam) + this.typeMatchQualityMetric(suprParam, typParam);
        return n;
    }

    public final Set<TypeName> avoidThose() {
        return this.avoidThose;
    }

    public final int aLotCost() {
        return 1000000;
    }

    public final int losingInformationCost() {
        return 10000;
    }

    public final int varToConcreteCost() {
        return 200;
    }

    public final int concreteToVarCost() {
        return 5000;
    }

    public final int andOrOrTypeCost() {
        return 50;
    }

    public final int dealiasCost() {
        return 10;
    }

    public final int subTypeCost() {
        return 100;
    }

    public final int typeLambdaCost() {
        return 1;
    }

    public final int varToVarCost() {
        return 1;
    }

    public final int equalCost() {
        return 1;
    }

    public ScalaAnnotatedSignaturePrettifier p() {
        return this.p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int typeMatchQualityMetric(TypeLike typ, TypeLike supr) {
        int n;
        Type s;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)typ, (Object)supr);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TypeLike typeLike = (TypeLike)tuple2._1();
        TypeLike typeLike2 = (TypeLike)tuple2._2();
        if (typeLike instanceof Type) {
            Type t;
            Type type;
            Type t2 = type = (Type)typeLike;
            if (typeLike2 instanceof Type) {
                Type s2 = (Type)typeLike2;
                if (t2.isStarProjection() && s2.isStarProjection()) {
                    return 1;
                }
            }
            if ((t = type).isStarProjection()) {
                return 200;
            }
        }
        if (typeLike2 instanceof Type && (s = (Type)typeLike2).isStarProjection()) {
            return 200;
        }
        if (typeLike instanceof AndType) {
            AndType andType = AndType$.MODULE$.unapply((AndType)typeLike);
            TypeLike typeLike3 = andType._1();
            TypeLike typeLike4 = andType._2();
            TypeLike left = typeLike3;
            TypeLike right = typeLike4;
            TypeLike supr2 = typeLike2;
            n = 50 + RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.typeMatchQualityMetric(left, supr2)), this.typeMatchQualityMetric(right, supr2));
            return n;
        } else {
            TypeLike typ2 = typeLike;
            if (typeLike2 instanceof AndType) {
                AndType andType = AndType$.MODULE$.unapply((AndType)typeLike2);
                TypeLike typeLike5 = andType._1();
                TypeLike typeLike6 = andType._2();
                TypeLike left = typeLike5;
                TypeLike right = typeLike6;
                n = 50 + RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.typeMatchQualityMetric(typ2, left)), this.typeMatchQualityMetric(typ2, right));
                return n;
            } else if (typeLike instanceof OrType) {
                OrType orType = OrType$.MODULE$.unapply((OrType)typeLike);
                TypeLike typeLike7 = orType._1();
                TypeLike typeLike8 = orType._2();
                TypeLike left = typeLike7;
                TypeLike right = typeLike8;
                TypeLike supr3 = typeLike2;
                n = 50 + RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.typeMatchQualityMetric(left, supr3)), this.typeMatchQualityMetric(right, supr3));
                return n;
            } else {
                TypeLike typ3 = typeLike;
                if (typeLike2 instanceof OrType) {
                    OrType orType = OrType$.MODULE$.unapply((OrType)typeLike2);
                    TypeLike typeLike9 = orType._1();
                    TypeLike typeLike10 = orType._2();
                    TypeLike left = typeLike9;
                    TypeLike right = typeLike10;
                    n = 50 + RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.typeMatchQualityMetric(typ3, left)), this.typeMatchQualityMetric(typ3, right));
                    return n;
                } else if (typeLike instanceof TypeLambda) {
                    TypeLambda typ4 = (TypeLambda)typeLike;
                    if (!(typeLike2 instanceof TypeLambda)) return 1000000;
                    TypeLambda supr4 = (TypeLambda)typeLike2;
                    IndexedSeq dummyTypes = this.genDummyTypes(typ4.args().size());
                    TypeLike typResult = this.substituteBindings(typ4.result(), ((IterableOnceOps)((IterableOps)typ4.args().flatMap((Function1 & Serializable)_$1 -> _$1.itid())).zip((IterableOnce)dummyTypes)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    TypeLike suprResult = this.substituteBindings(supr4.result(), ((IterableOnceOps)((IterableOps)supr4.args().flatMap((Function1 & Serializable)_$2 -> _$2.itid())).zip((IterableOnce)dummyTypes)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    n = 1 + this.typeMatchQualityMetric(typResult, suprResult);
                    return n;
                } else {
                    Type type;
                    Type type2;
                    if (typeLike2 instanceof TypeLambda) {
                        return 1000000;
                    }
                    if (!(typeLike instanceof Type)) throw new MatchError((Object)tuple2);
                    Type typ5 = type2 = (Type)typeLike;
                    if (!(typeLike2 instanceof Type)) throw new MatchError((Object)tuple2);
                    Type supr5 = type = (Type)typeLike2;
                    if (typ5.isVariable() && typ5.isGeneric() && supr5.isVariable() && supr5.isGeneric()) {
                        n = 1 + this.variancesMatchQualityMetric(typ5.params(), supr5.params());
                        return n;
                    } else {
                        Type typ6 = type2;
                        Type supr6 = type;
                        if (typ6.isVariable() && typ6.isGeneric() && supr6.isGeneric()) {
                            n = 200 + this.variancesMatchQualityMetric(typ6.params(), supr6.params());
                            return n;
                        } else {
                            Type typ7 = type2;
                            Type supr7 = type;
                            if (supr7.isVariable() && supr7.isGeneric() && typ7.isGeneric()) {
                                n = 5000 + this.variancesMatchQualityMetric(typ7.params(), supr7.params());
                                return n;
                            } else {
                                Type typ8 = type2;
                                if (typ8.isVariable() && typ8.isGeneric()) {
                                    return 10000;
                                }
                                Type supr8 = type;
                                if (supr8.isVariable() && supr8.isGeneric()) {
                                    return 10000;
                                }
                                Type typ9 = type2;
                                Type supr9 = type;
                                if (typ9.isVariable() && supr9.isVariable()) {
                                    return 1;
                                }
                                Type typ10 = type2;
                                Type supr10 = type;
                                if (typ10.isVariable() && supr10.isGeneric()) {
                                    return 10000;
                                }
                                Type typ11 = type2;
                                Type supr11 = type;
                                if (supr11.isVariable() && typ11.isGeneric()) {
                                    return 10000;
                                }
                                Type supr12 = type;
                                if (supr12.isVariable()) {
                                    return 5000;
                                }
                                Type typ12 = type2;
                                if (typ12.isVariable()) {
                                    return 200;
                                }
                                Type typ13 = type2;
                                Type supr13 = type;
                                if (typ13.isGeneric() && !supr13.isGeneric()) {
                                    return 10000;
                                }
                                Type typ14 = type2;
                                Type supr14 = type;
                                if (!this.isGeneralised(typ14) && this.isGeneralised(supr14)) {
                                    return 10000;
                                }
                                Type typ15 = type2;
                                Type supr15 = type;
                                if (!this.isGeneralised(supr15) && this.isGeneralised(typ15)) {
                                    return 10000;
                                }
                                Type typ16 = type2;
                                Type supr16 = type;
                                n = 1 + this.variancesMatchQualityMetric(typ16.params(), supr16.params());
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public boolean isGeneralised(TypeLike typ) {
        boolean bl;
        TypeLike typeLike = typ;
        if (typeLike instanceof AndType) {
            AndType andType = AndType$.MODULE$.unapply((AndType)typeLike);
            TypeLike typeLike2 = andType._1();
            TypeLike typeLike3 = andType._2();
            TypeLike left = typeLike2;
            TypeLike right = typeLike3;
            bl = this.isGeneralised(left) || this.isGeneralised(right);
        } else if (typeLike instanceof OrType) {
            OrType orType = OrType$.MODULE$.unapply((OrType)typeLike);
            TypeLike typeLike4 = orType._1();
            TypeLike typeLike5 = orType._2();
            TypeLike left = typeLike4;
            TypeLike right = typeLike5;
            bl = this.isGeneralised(left) || this.isGeneralised(right);
        } else if (typeLike instanceof TypeLambda) {
            TypeLambda t = (TypeLambda)typeLike;
            bl = this.isGeneralised(t.result());
        } else if (typeLike instanceof Type) {
            Type t = (Type)typeLike;
            bl = this.avoidThose().contains((Object)t.name());
        } else {
            throw new MatchError((Object)typeLike);
        }
        return bl;
    }
}

