/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.milyn.Smooks;
import org.milyn.SmooksUtil;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.delivery.ContentDeliveryConfig;

public abstract class ParameterAccessor {
    public static final String GLOBAL_PARAMETERS = "global-parameters";

    public static Object getParameterObject(String name, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue(config);
        }
        return null;
    }

    public static String getStringParameter(String name, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    public static String getStringParameter(String name, String defaultVal, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        if (param != null) {
            return param.getValue();
        }
        return defaultVal;
    }

    public static boolean getBoolParameter(String name, boolean defaultVal, ContentDeliveryConfig config) {
        Parameter param = ParameterAccessor.getParamter(name, config);
        return ParameterAccessor.toBoolean(param, defaultVal);
    }

    public static boolean getBoolParameter(String name, boolean defaultVal, Map<String, List<SmooksResourceConfiguration>> config) {
        Parameter param = ParameterAccessor.getParameter(name, config);
        return ParameterAccessor.toBoolean(param, defaultVal);
    }

    private static boolean toBoolean(Parameter param, boolean defaultVal) {
        if (param == null) {
            return defaultVal;
        }
        String paramVal = param.getValue();
        if (paramVal == null) {
            return defaultVal;
        }
        if ((paramVal = paramVal.trim()).equals("true")) {
            return true;
        }
        if (paramVal.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    public static Parameter getParamter(String name, ContentDeliveryConfig config) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(config, "config");
        return ParameterAccessor.getParameter(name, config.getSmooksResourceConfigurations());
    }

    public static Parameter getParameter(String name, Map<String, List<SmooksResourceConfiguration>> resourceConfigurations) {
        String systemValue;
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(resourceConfigurations, "resourceConfigurations");
        List<SmooksResourceConfiguration> configList = resourceConfigurations.get(GLOBAL_PARAMETERS);
        if (configList != null) {
            List<SmooksResourceConfiguration> cbConfigList = resourceConfigurations.get("device-parameters");
            if (cbConfigList != null) {
                configList.addAll(cbConfigList);
            }
            for (SmooksResourceConfiguration resourceConfig : configList) {
                Parameter param = resourceConfig.getParameter(name);
                if (param == null) continue;
                return param;
            }
        }
        if ((systemValue = System.getProperty(name)) != null) {
            return new Parameter(name, systemValue);
        }
        return null;
    }

    public static String getStringParameter(String name, Map<String, List<SmooksResourceConfiguration>> resourceConfigurations) {
        Parameter parameter = ParameterAccessor.getParameter(name, resourceConfigurations);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    public static void setParameter(String name, String value, Smooks smooks) {
        SmooksResourceConfiguration config = new SmooksResourceConfiguration(GLOBAL_PARAMETERS);
        config.setParameter(name, value);
        SmooksUtil.registerResource(config, smooks);
    }

    public static void removeParameter(String name, Smooks smooks) {
        SmooksResourceConfigurationStore configStore = smooks.getApplicationContext().getStore();
        Iterator<SmooksResourceConfigurationList> configLists = configStore.getSmooksResourceConfigurationLists();
        while (configLists.hasNext()) {
            SmooksResourceConfigurationList list = configLists.next();
            for (int i = 0; i < list.size(); ++i) {
                SmooksResourceConfiguration nextConfig = list.get(i);
                if (!GLOBAL_PARAMETERS.equals(nextConfig.getSelector())) continue;
                nextConfig.removeParameter(name);
            }
        }
    }
}

