/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ExecutionContext;
import org.milyn.io.NullReader;
import org.milyn.io.NullWriter;
import org.milyn.thread.StackedThreadLocal;

public abstract class Filter {
    private static Log logger = LogFactory.getLog(Filter.class);
    public static final String STREAM_FILTER_TYPE = "stream.filter.type";
    private static final StackedThreadLocal<Filter> filterThreadLocal = new StackedThreadLocal("Filter");
    private static final StackedThreadLocal<ExecutionContext> execThreadLocal = new StackedThreadLocal("ExecutionContext");
    public static final String CLOSE_SOURCE = "close.source";
    public static final String CLOSE_RESULT = "close.result";
    public static final String ENTITIES_REWRITE = "entities.rewrite";
    public static final String DEFAULT_SERIALIZATION_ON = "default.serialization.on";
    public static final String MAINTAIN_ELEMENT_STACK = "maintain.element.stack";
    public static final String REVERSE_VISIT_ORDER_ON_VISIT_AFTER = "reverse.visit.order.on.visit.after";
    public static final String TERMINATE_ON_VISITOR_EXCEPTION = "terminate.on.visitor.exception";
    public static final String READER_POOL_SIZE = "reader.pool.size";

    public abstract void doFilter() throws SmooksException;

    public abstract void cleanup();

    public static void setFilterType(Smooks smooks, org.milyn.StreamFilterType filterType) {
        ParameterAccessor.setParameter(STREAM_FILTER_TYPE, filterType.toString(), smooks);
    }

    public static void setFilterType(Smooks smooks, StreamFilterType filterType) {
        ParameterAccessor.setParameter(STREAM_FILTER_TYPE, filterType.toString(), smooks);
    }

    public static Filter getFilter() {
        Filter filter = filterThreadLocal.get();
        if (filter == null) {
            throw new IllegalStateException("Call to getFilter() before the filter is set for the Thread.  This method can only be called within the context of a Smooks execution, which sets the filter.");
        }
        return filter;
    }

    public static void setFilter(Filter filter) {
        filterThreadLocal.set(filter);
    }

    public static void removeCurrentFilter() {
        filterThreadLocal.remove();
    }

    public static ExecutionContext getCurrentExecutionContext() {
        return execThreadLocal.get();
    }

    public static void setCurrentExecutionContext(ExecutionContext executionContext) {
        execThreadLocal.set(executionContext);
    }

    public static void removeCurrentExecutionContext() {
        execThreadLocal.remove();
    }

    protected Reader getReader(Source source, ExecutionContext executionContext) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getReader() != null) {
                return streamSource.getReader();
            }
            if (streamSource.getInputStream() != null) {
                try {
                    if (executionContext instanceof ExecutionContext) {
                        return new InputStreamReader(streamSource.getInputStream(), executionContext.getContentEncoding());
                    }
                    return new InputStreamReader(streamSource.getInputStream(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmooksException("Unable to decode input stream.", e);
                }
            }
            throw new SmooksException("Invalid " + StreamSource.class.getName() + ".  No InputStream or Reader instance.");
        }
        return new NullReader();
    }

    protected Writer getWriter(Result result, ExecutionContext executionContext) {
        if (!(result instanceof StreamResult)) {
            return new NullWriter();
        }
        StreamResult streamResult = (StreamResult)result;
        if (streamResult.getWriter() != null) {
            return streamResult.getWriter();
        }
        if (streamResult.getOutputStream() != null) {
            try {
                if (executionContext instanceof ExecutionContext) {
                    return new OutputStreamWriter(streamResult.getOutputStream(), executionContext.getContentEncoding());
                }
                return new OutputStreamWriter(streamResult.getOutputStream(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmooksException("Unable to encode output stream.", e);
            }
        }
        throw new SmooksException("Invalid " + StreamResult.class.getName() + ".  No OutputStream or Writer instance.");
    }

    protected void close(Source source) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            try {
                InputStream inputStream;
                if (streamSource.getReader() != null) {
                    streamSource.getReader().close();
                } else if (streamSource.getInputStream() != null && (inputStream = streamSource.getInputStream()) != System.in) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Failed to close input stream/reader.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Result result) {
        block11: {
            if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                try {
                    if (streamResult.getWriter() != null) {
                        try (Writer writer = streamResult.getWriter();){
                            writer.flush();
                            break block11;
                        }
                    }
                    if (streamResult.getOutputStream() == null) break block11;
                    OutputStream stream = streamResult.getOutputStream();
                    try {
                        stream.flush();
                    }
                    finally {
                        if (stream != System.out && stream != System.err) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.debug((Object)"Failed to close output stream/writer.  May already be closed.", throwable);
                }
            }
        }
    }

    public static enum StreamFilterType {
        SAX,
        DOM;

    }
}

