/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.xml.DomUtils;
import org.milyn.xml.Namespace;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ContextObjectSerializationUnit
implements SerializationUnit,
SAXElementVisitor {
    private static Log logger = LogFactory.getLog(ContextObjectSerializationUnit.class);

    @Override
    public void writeElementStart(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        String key = ContextObjectSerializationUnit.getContextKey(element);
        if (key != null) {
            Object object = executionContext.getAttribute(key);
            if (object != null) {
                writer.write(object.toString());
            } else {
                logger.debug((Object)("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. No Object instance found on context at '" + key + "'."));
            }
        } else {
            logger.warn((Object)("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. 'key' attribute not specified."));
        }
    }

    public static String getContextKey(Element element) {
        return DomUtils.getAttributeValue(element, "key");
    }

    @Override
    public void writeElementEnd(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public void writeElementText(Text text, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    @Override
    public boolean writeChildElements() {
        return false;
    }

    public static Element createElement(Document ownerDocument, String key) {
        Element resultElement = ownerDocument.createElementNS(Namespace.SMOOKS_URI, "context-object");
        Comment comment = ownerDocument.createComment(" The actual message payload is set on the associated Smooks ExecutionContext under the key '" + key + "'.  Alternatively, you can use Smooks to serialize the message. ");
        resultElement.setAttribute("key", key);
        resultElement.appendChild(comment);
        return resultElement;
    }

    public static boolean isContextObjectElement(Element element) {
        return DomUtils.getName(element).equals("context-object") && Namespace.SMOOKS_URI.equals(element.getNamespaceURI());
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
    }
}

