/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.delivery.ConfigurationExpander;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.VisitPhase;
import org.milyn.javabean.BeanInstanceCreator;
import org.milyn.javabean.BeanInstancePopulator;
import org.milyn.javabean.ext.SelectorPropertyResolver;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanPopulator
implements ConfigurationExpander {
    private static Log logger = LogFactory.getLog(BeanPopulator.class);
    public static String GLOBAL_DEFAULT_EXTEND_LIFECYCLE = "binding.extend.lifecycle";
    public static String GLOBAL_DEFAULT_FACTORY_DEFINITION_PARSER_CLASS = "factory.definition.parser.class";
    public static String DEFAULT_FACTORY_DEFINITION_PARSER_CLASS = "org.milyn.javabean.factory.BasicFactoryDefinitionParser";
    @ConfigParam(name="beanId", defaultVal="##NULL")
    private String beanIdName;
    @ConfigParam(name="beanClass", defaultVal="##NULL")
    private String beanClassName;
    @ConfigParam(name="beanFactory", defaultVal="##NULL")
    private String beanFactory;
    @ConfigParam(defaultVal="true")
    private boolean create;
    @ConfigParam(defaultVal="##NULL")
    private String extendLifecycle;
    @Config
    private SmooksResourceConfiguration config;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        if (StringUtils.isBlank((String)this.beanClassName)) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration. 'beanClass' <param> not specified.");
        }
        this.beanClassName = this.beanClassName.trim();
        this.beanFactory = StringUtils.trim((String)this.beanFactory);
        if (this.beanIdName == null || this.beanIdName.trim().length() == 0) {
            this.beanIdName = this.toBeanId(this.beanClassName);
            logger.debug((Object)("No 'beanId' specified for beanClass '" + this.beanClassName + "'. Defaulting beanId to '" + this.beanIdName + "'."));
        }
        if (this.config.getStringParameter("attributeName") != null) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration. 'attributeName' param config no longer supported.  Please use the <bindings> config style.");
        }
        if (this.config.getStringParameter("setterName") != null) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration. 'setterName' param config no longer supported.  Please use the <bindings> config style.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean Populator created for '" + this.beanIdName + "'"));
        }
    }

    @Override
    public List<SmooksResourceConfiguration> expandConfigurations() throws SmooksConfigurationException {
        ArrayList<SmooksResourceConfiguration> resources = new ArrayList<SmooksResourceConfiguration>();
        this.buildInstanceCreatorConfig(resources);
        this.buildBindingConfigs(resources);
        return resources;
    }

    private void buildInstanceCreatorConfig(List<SmooksResourceConfiguration> resources) {
        SmooksResourceConfiguration resource = (SmooksResourceConfiguration)this.config.clone();
        resource.removeParameter("beanId");
        resource.setParameter("beanId", this.beanIdName);
        resource.removeParameter("beanClass");
        resource.setParameter("beanClass", this.beanClassName);
        if (this.beanFactory != null) {
            resource.removeParameter("beanFactory");
            resource.setParameter("beanFactory", this.beanFactory);
        }
        resource.removeParameter("bindings");
        if (!this.create) {
            resource.setSelector("$void");
        }
        resource.setResource(BeanInstanceCreator.class.getName());
        resources.add(resource);
    }

    private void buildBindingConfigs(List<SmooksResourceConfiguration> resources) {
        Parameter bindingsParam = this.config.getParameter("bindings");
        if (bindingsParam != null) {
            Element bindingsParamElement = bindingsParam.getXml();
            if (bindingsParamElement != null) {
                NodeList bindings = bindingsParamElement.getElementsByTagName("binding");
                try {
                    for (int i = 0; bindings != null && i < bindings.getLength(); ++i) {
                        Element node = (Element)bindings.item(i);
                        resources.add(this.buildInstancePopulatorConfig(node));
                    }
                }
                catch (IOException e) {
                    throw new SmooksConfigurationException("Failed to read binding configuration for " + this.config, e);
                }
            } else {
                logger.error((Object)"Sorry, the Javabean populator bindings must be available as XML DOM.  Please configure using XML.");
            }
        }
    }

    private SmooksResourceConfiguration buildInstancePopulatorConfig(Element bindingConfig) throws IOException, SmooksConfigurationException {
        String expression;
        String wireBeanId = null;
        String selector = this.getSelectorAttr(bindingConfig);
        if (selector.startsWith("${") && selector.endsWith("}")) {
            wireBeanId = selector.substring(2, selector.length() - 1);
            selector = this.config.getSelector();
        }
        String setterMethod = DomUtils.getAttributeValue(bindingConfig, "setterMethod");
        String property = DomUtils.getAttributeValue(bindingConfig, "property");
        String[] selectorTokens = SmooksResourceConfiguration.parseSelector(selector);
        String attributeNameProperty = SmooksResourceConfiguration.extractTargetAttribute(selectorTokens);
        String selectorProperty = SelectorPropertyResolver.getSelectorProperty(selectorTokens);
        SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration(selectorProperty, BeanInstancePopulator.class.getName());
        resourceConfig.setParameter(VisitPhase.class.getSimpleName(), this.config.getStringParameter(VisitPhase.class.getSimpleName(), VisitPhase.PROCESSING.toString()));
        resourceConfig.setParameter("beanId", this.beanIdName);
        if (wireBeanId != null) {
            resourceConfig.setParameter("wireBeanId", wireBeanId);
        }
        if (setterMethod != null) {
            resourceConfig.setParameter("setterMethod", setterMethod);
        }
        if (property != null) {
            resourceConfig.setParameter("property", property);
        }
        if (attributeNameProperty != null && !attributeNameProperty.trim().equals("")) {
            resourceConfig.setParameter("valueAttributeName", attributeNameProperty);
        } else if (wireBeanId == null && (expression = DomUtils.getAllText(bindingConfig, true)) != null && !(expression = expression.trim()).equals("")) {
            resourceConfig.setParameter("expression", expression);
        }
        String type = DomUtils.getAttributeValue(bindingConfig, "type");
        String defaultVal = DomUtils.getAttributeValue(bindingConfig, "default");
        if (wireBeanId == null) {
            if (type != null) {
                resourceConfig.setParameter("type", type);
            }
            if (defaultVal != null) {
                resourceConfig.setParameter("default", defaultVal);
            }
        } else {
            if (type != null) {
                throw new SmooksConfigurationException("The 'type' attribute isn't a allowed when binding a bean: " + bindingConfig);
            }
            if (defaultVal != null) {
                throw new SmooksConfigurationException("The 'default' attribute isn't a allowed when binding a bean: " + bindingConfig);
            }
        }
        resourceConfig.setTargetProfile(this.config.getTargetProfile());
        String selectorNamespace = DomUtils.getAttributeValue(bindingConfig, "selector-namespace");
        if (selectorNamespace == null) {
            selectorNamespace = this.config.getSelectorNamespaceURI();
        }
        resourceConfig.setSelectorNamespaceURI(selectorNamespace);
        if (this.extendLifecycle != null) {
            resourceConfig.setParameter("extendLifecycle", this.extendLifecycle);
        }
        return resourceConfig;
    }

    private String toBeanId(String beanClassName) {
        String[] beanClassNameTokens = beanClassName.split("\\.");
        StringBuffer simpleClassName = new StringBuffer(beanClassNameTokens[beanClassNameTokens.length - 1]);
        simpleClassName.setCharAt(0, Character.toLowerCase(simpleClassName.charAt(0)));
        return simpleClassName.toString();
    }

    private String getSelectorAttr(Element bindingConfig) {
        String selector = DomUtils.getAttributeValue(bindingConfig, "selector");
        if (selector == null) {
            selector = this.config.getSelector();
        }
        return selector;
    }
}

