/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.repository.BeanId;
import org.w3c.dom.Element;

public class StaticVariableBinder
implements SAXElementVisitor,
DOMElementVisitor {
    private static final String STATVAR = "statvar";
    private BeanId beanId;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.beanId = this.appContext.getBeanIdStore().getBeanId(STATVAR);
        if (this.beanId == null) {
            this.beanId = this.appContext.getBeanIdStore().register(STATVAR);
        }
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bindParamaters(executionContext, new Fragment(element));
    }

    @Override
    public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bindParamaters(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    private void bindParamaters(ExecutionContext executionContext, Fragment source) {
        List params = this.config.getParameterList();
        for (Object parameter : params) {
            if (parameter instanceof List) {
                this.bindParameter((Parameter)((List)parameter).get(0), executionContext, source);
                continue;
            }
            if (!(parameter instanceof Parameter)) continue;
            this.bindParameter((Parameter)parameter, executionContext, source);
        }
    }

    private void bindParameter(Parameter parameter, ExecutionContext executionContext, Fragment source) {
        HashMap<String, Object> params = null;
        BeanContext beanContext = executionContext.getBeanContext();
        try {
            HashMap<String, Object> castParams;
            params = castParams = (HashMap<String, Object>)beanContext.getBean(this.beanId);
        }
        catch (ClassCastException e) {
            throw new SmooksException("Illegal use of reserved beanId 'statvar'.  Must be a Map.  Is a " + params.getClass().getName(), e);
        }
        if (params == null) {
            params = new HashMap<String, Object>();
            beanContext.addBean(this.beanId, params, source);
        }
        params.put(parameter.getName(), parameter.getValue(executionContext.getDeliveryConfig()));
    }
}

