/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Filter;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.BigDecimalDecoder;

@DecodeType(value={BigDecimal.class})
public class DABigDecimalDecoder
extends BigDecimalDecoder {
    @Override
    public Object decode(String data) throws DataDecodeException {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        try {
            this.setDecimalPointFormat(decimalFormat, this.getContextDelimiters());
            Number number = decimalFormat.parse(data.trim());
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        catch (ParseException e) {
            throw new DataDecodeException("Failed to decode BigDecimal value '" + data + "' using NumberFormat instance " + decimalFormat + ".", e);
        }
    }

    @Override
    public String encode(Object object) throws DataDecodeException {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        return decimalFormat.format(object);
    }

    public String encode(Object object, Delimiters interchangeDelimiters) throws DataDecodeException {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        this.setDecimalPointFormat(decimalFormat, interchangeDelimiters);
        return decimalFormat.format(object);
    }

    private synchronized DecimalFormat getDecimalFormat() {
        NumberFormat parentNumberFormat = this.getNumberFormat();
        if (parentNumberFormat != null && parentNumberFormat instanceof DecimalFormat) {
            return (DecimalFormat)parentNumberFormat.clone();
        }
        return new DecimalFormat();
    }

    private synchronized void setDecimalPointFormat(DecimalFormat decimalFormat, Delimiters interchangeDelimiters) {
        DecimalFormatSymbols dfs = decimalFormat.getDecimalFormatSymbols();
        decimalFormat.applyPattern("#0.0#");
        if (interchangeDelimiters != null) {
            dfs.setDecimalSeparator(interchangeDelimiters.getDecimalSeparator().charAt(0));
        }
        decimalFormat.setDecimalFormatSymbols(dfs);
    }

    protected Delimiters getContextDelimiters() {
        ExecutionContext ec = Filter.getCurrentExecutionContext();
        Delimiters delimiters = null;
        if (ec != null) {
            delimiters = ec.getBeanContext().getBean(Delimiters.class);
        }
        return delimiters;
    }
}

