/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.ext;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.javabean.dynamic.serialize.BeanWriter;

public class BeanWriterFactory
implements ContentHandler {
    @ConfigParam
    private String beanId;
    @ConfigParam(name="class")
    private Class<? extends BeanWriter> beanWriterClass;
    @ConfigParam(name="beanClass")
    private Class<?> beanClass;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void createBeanWriter() {
        try {
            BeanWriter beanWriter = this.beanWriterClass.newInstance();
            Configurator.configure(beanWriter, this.config, this.appContext);
            BeanWriterFactory.getBeanWriters(this.beanClass, this.appContext).put(this.config.getSelectorNamespaceURI(), beanWriter);
        }
        catch (InstantiationException e) {
            throw new SmooksConfigurationException("Unable to create BeanWriter instance.", e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Unable to create BeanWriter instance.", e);
        }
    }

    public static Map<String, BeanWriter> getBeanWriters(Class<?> beanClass, ApplicationContext appContext) {
        Map<Class<?>, Map<String, BeanWriter>> beanWriterMap = BeanWriterFactory.getBeanWriters(appContext);
        Map<String, BeanWriter> beanWriters = beanWriterMap.get(beanClass);
        if (beanWriters == null) {
            beanWriters = new LinkedHashMap<String, BeanWriter>();
            beanWriterMap.put(beanClass, beanWriters);
        }
        return beanWriters;
    }

    public static Map<Class<?>, Map<String, BeanWriter>> getBeanWriters(ApplicationContext appContext) {
        HashMap beanWriters = (HashMap)appContext.getAttribute(BeanWriter.class);
        if (beanWriters == null) {
            beanWriters = new HashMap();
            appContext.setAttribute(BeanWriter.class, beanWriters);
        }
        return beanWriters;
    }
}

