/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.camel.converters;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.Message;
import org.apache.camel.spi.TypeConverterRegistry;
import org.milyn.payload.JavaResult;
import org.milyn.payload.StringResult;
import org.w3c.dom.Node;

@Converter
public class ResultConverter {
    public static final String SMOOKS_RESULT_KEY = "SmooksResultKeys";

    private ResultConverter() {
    }

    @Converter
    public static Node toDocument(DOMResult domResult) {
        return domResult.getNode();
    }

    @Converter
    public static List toList(JavaResult.ResultMap javaResult, Exchange exchange) {
        String resultKey = (String)exchange.getProperty(SMOOKS_RESULT_KEY);
        if (resultKey != null) {
            return (List)ResultConverter.getResultsFromJavaResult(javaResult, resultKey);
        }
        return (List)ResultConverter.getSingleObjectFromJavaResult(javaResult);
    }

    @Converter
    public static Integer toInteger(JavaResult.ResultMap result) {
        return (Integer)ResultConverter.getSingleObjectFromJavaResult(result);
    }

    @Converter
    public static Double toDouble(JavaResult.ResultMap result) {
        return (Double)ResultConverter.getSingleObjectFromJavaResult(result);
    }

    @Converter
    public static String toString(StringResult result) {
        return result.getResult();
    }

    @Converter
    public static Map toMap(JavaResult.ResultMap resultBeans, Exchange exchange) {
        Message outMessage = exchange.getOut();
        outMessage.setBody((Object)resultBeans);
        Set entrySet = resultBeans.entrySet();
        for (Map.Entry entry : entrySet) {
            outMessage.setBody(entry.getValue(), entry.getValue().getClass());
        }
        return resultBeans;
    }

    private static Object getResultsFromJavaResult(JavaResult.ResultMap resultMap, String resultKey) {
        return resultMap.get(resultKey);
    }

    private static Object getSingleObjectFromJavaResult(JavaResult.ResultMap resultMap) {
        if (resultMap.size() == 1) {
            return resultMap.values().iterator().next();
        }
        return null;
    }

    @Converter
    public static StreamSource toStreamSource(StringResult stringResult) {
        String result = stringResult.getResult();
        if (result != null) {
            StringReader stringReader = new StringReader(result);
            return new StreamSource(stringReader);
        }
        return null;
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (value instanceof JavaResult.ResultMap) {
            for (Object mapValue : ((Map)value).values()) {
                if (!type.isInstance(mapValue)) continue;
                return type.cast(mapValue);
            }
        }
        return null;
    }
}

