/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath.evaluators;

import java.util.ArrayList;
import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.sax.SAXElement;
import org.w3c.dom.Element;

public class PredicatesEvaluator
extends XPathExpressionEvaluator {
    private List<XPathExpressionEvaluator> evaluators = new ArrayList<XPathExpressionEvaluator>();
    private int evalCount;

    public void addEvaluator(XPathExpressionEvaluator evaluator) {
        AssertArgument.isNotNull((Object)evaluator, (String)"evaluator");
        this.evaluators.add(evaluator);
        this.evalCount = this.evaluators.size();
    }

    public List<XPathExpressionEvaluator> getEvaluators() {
        return this.evaluators;
    }

    @Override
    public boolean evaluate(SAXElement element, ExecutionContext executionContext) {
        for (int i = 0; i < this.evalCount; ++i) {
            if (this.evaluators.get(i).evaluate(element, executionContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(Element element, ExecutionContext executionContext) {
        for (int i = 0; i < this.evalCount; ++i) {
            if (this.evaluators.get(i).evaluate(element, executionContext)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.evaluators.isEmpty()) {
            for (XPathExpressionEvaluator evaluator : this.evaluators) {
                if (builder.length() > 0) {
                    builder.append(" and ");
                }
                builder.append(evaluator);
            }
        }
        return builder.toString();
    }
}

