/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.container.standalone;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Hashtable;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryConfigBuilder;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.event.ExecutionEventListener;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.StandaloneBeanContextFactory;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.UnknownProfileMemberException;

public class StandaloneExecutionContext
implements ExecutionContext {
    private ProfileSet targetProfileSet;
    private Hashtable<Object, Object> attributes = new Hashtable();
    private ContentDeliveryConfig deliveryConfig;
    private URI docSource;
    private String contentEncoding;
    private ApplicationContext context;
    private ExecutionEventListener executionListener;
    private Throwable terminationError;
    private boolean isDefaultSerializationOn;
    private BeanContext beanContext;

    public StandaloneExecutionContext(String targetProfile, ApplicationContext context, VisitorConfigMap extendedVisitorConfigMap) throws UnknownProfileMemberException {
        this(targetProfile, context, "UTF-8", extendedVisitorConfigMap);
    }

    public StandaloneExecutionContext(String targetProfile, ApplicationContext context, String contentEncoding, VisitorConfigMap extendedVisitorConfigMap) throws UnknownProfileMemberException {
        if (targetProfile == null) {
            throw new IllegalArgumentException("null 'targetProfile' arg in constructor call.");
        }
        if (context == null) {
            throw new IllegalArgumentException("null 'context' arg in constructor call.");
        }
        this.context = context;
        this.setContentEncoding(contentEncoding);
        this.targetProfileSet = context.getProfileStore().getProfileSet(targetProfile);
        this.deliveryConfig = ContentDeliveryConfigBuilder.getConfig(this.targetProfileSet, context, extendedVisitorConfigMap);
        this.isDefaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, this.deliveryConfig);
    }

    @Override
    public void setDocumentSource(URI docSource) {
        this.docSource = docSource;
    }

    @Override
    public URI getDocumentSource() {
        if (this.docSource == null) {
            return ExecutionContext.DOCUMENT_URI;
        }
        return this.docSource;
    }

    @Override
    public ApplicationContext getContext() {
        return this.context;
    }

    @Override
    public ProfileSet getTargetProfiles() {
        return this.targetProfileSet;
    }

    @Override
    public ContentDeliveryConfig getDeliveryConfig() {
        return this.deliveryConfig;
    }

    @Override
    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        contentEncoding = contentEncoding == null ? "UTF-8" : contentEncoding;
        try {
            "".getBytes(contentEncoding);
        }
        catch (UnsupportedEncodingException e) {
            IllegalArgumentException argE = new IllegalArgumentException("Invalid 'contentEncoding' arg [" + contentEncoding + "].  This encoding is not supported.");
            argE.initCause(e);
            throw argE;
        }
        this.contentEncoding = contentEncoding;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding == null ? "UTF-8" : this.contentEncoding;
    }

    @Override
    public void setEventListener(ExecutionEventListener listener) {
        this.executionListener = listener;
    }

    @Override
    public ExecutionEventListener getEventListener() {
        return this.executionListener;
    }

    @Override
    public void setTerminationError(Throwable terminationError) {
        this.terminationError = terminationError;
    }

    @Override
    public Throwable getTerminationError() {
        return this.terminationError;
    }

    @Override
    public String getConfigParameter(String name) {
        return this.getConfigParameter(name, null);
    }

    @Override
    public String getConfigParameter(String name, String defaultVal) {
        return ParameterAccessor.getStringParameter(name, defaultVal, this.deliveryConfig);
    }

    @Override
    public boolean isDefaultSerializationOn() {
        return this.isDefaultSerializationOn;
    }

    @Override
    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public String toString() {
        return this.attributes.toString();
    }

    public Hashtable<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public BeanContext getBeanContext() {
        if (this.beanContext == null) {
            this.beanContext = StandaloneBeanContextFactory.create(this);
        }
        return this.beanContext;
    }

    @Override
    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }
}

