/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.TextType;
import org.milyn.xml.HTMLEntityLookup;
import org.milyn.xml.XmlUtil;
import org.xml.sax.Attributes;

public class SAXElementWriterUtil {
    public static void writeEmptyElement(SAXElement element, Writer writer, boolean encodeSpecialChars) throws IOException {
        if (writer != null) {
            SAXElementWriterUtil.writeUnclosedElement(element, writer, encodeSpecialChars);
            writer.write(" />");
        }
    }

    public static void writeStartElement(SAXElement element, Writer writer, boolean encodeSpecialChars) throws IOException {
        if (writer != null) {
            SAXElementWriterUtil.writeUnclosedElement(element, writer, encodeSpecialChars);
            writer.write(">");
        }
    }

    public static void writeEndElement(SAXElement element, Writer writer) throws IOException {
        if (writer != null) {
            QName name = element.getName();
            String prefix = name.getPrefix();
            writer.write("</");
            if (prefix != null && !prefix.equals("")) {
                writer.write(prefix);
                writer.write(58);
            }
            writer.write(name.getLocalPart());
            writer.write(62);
        }
    }

    public static void writeText(String text, TextType textType, Writer writer) throws IOException {
        if (writer != null) {
            switch (textType) {
                case TEXT: {
                    writer.write(text);
                    break;
                }
                case CDATA: {
                    writer.write("<![CDATA[");
                    writer.write(text);
                    writer.write("]]>");
                    break;
                }
                case COMMENT: {
                    writer.write("<!--");
                    writer.write(text);
                    writer.write("-->");
                    break;
                }
                case ENTITY: {
                    writer.write("&");
                    writer.write(HTMLEntityLookup.getEntityRef((char)text.charAt(0)));
                    writer.write(59);
                }
            }
        }
    }

    public static void writeText(SAXText text, Writer writer) throws IOException {
        if (writer != null) {
            switch (text.getType()) {
                case TEXT: {
                    writer.write(text.getCharacters(), text.getOffset(), text.getLength());
                    break;
                }
                case CDATA: {
                    writer.write("<![CDATA[");
                    writer.write(text.getCharacters(), text.getOffset(), text.getLength());
                    writer.write("]]>");
                    break;
                }
                case COMMENT: {
                    writer.write("<!--");
                    writer.write(text.getCharacters(), text.getOffset(), text.getLength());
                    writer.write("-->");
                    break;
                }
                case ENTITY: {
                    writer.write("&");
                    writer.write(HTMLEntityLookup.getEntityRef((char)text.getCharacters()[text.getOffset()]));
                    writer.write(59);
                }
            }
        }
    }

    private static void writeUnclosedElement(SAXElement element, Writer writer, boolean encodeSpecialChars) throws IOException {
        QName name = element.getName();
        String prefix = name.getPrefix();
        writer.write(60);
        if (prefix != null && !prefix.equals("")) {
            writer.write(prefix);
            writer.write(58);
        }
        writer.write(name.getLocalPart());
        SAXElementWriterUtil.writeAttributes(element.getAttributes(), writer, encodeSpecialChars);
    }

    private static void writeAttributes(Attributes attributes, Writer writer, boolean encodeSpecialChars) throws IOException {
        if (attributes != null) {
            int attribCount = attributes.getLength();
            for (int i = 0; i < attribCount; ++i) {
                String attQName = attributes.getQName(i);
                String attValue = attributes.getValue(i);
                writer.write(32);
                if (attQName != null && attQName.length() > 0) {
                    writer.write(attQName);
                } else {
                    writer.write(attributes.getLocalName(i));
                }
                if (encodeSpecialChars) {
                    writer.write("=\"");
                    XmlUtil.encodeAttributeValue((char[])attValue.toCharArray(), (int)0, (int)attValue.length(), (Writer)writer);
                    writer.write(34);
                    continue;
                }
                if (attValue.indexOf(34) != -1) {
                    writer.write("='");
                    writer.write(attValue);
                    writer.write(39);
                    continue;
                }
                writer.write("=\"");
                writer.write(attValue);
                writer.write(34);
            }
        }
    }
}

