/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import javax.xml.namespace.QName;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class SAXUtil {
    public static String getAttribute(String attributeName, Attributes attributes) {
        return SAXUtil.getAttribute(attributeName, attributes, "");
    }

    public static String getAttribute(String attributeName, Attributes attributes, String defaultVal) {
        int attribCount = attributes.getLength();
        for (int i = 0; i < attribCount; ++i) {
            String attribName = attributes.getLocalName(i);
            if (!attribName.equalsIgnoreCase(attributeName)) continue;
            return attributes.getValue(i);
        }
        return defaultVal;
    }

    public static String getAttribute(String attributeNamespace, String attributeName, Attributes attributes, String defaultVal) {
        int attribCount = attributes.getLength();
        for (int i = 0; i < attribCount; ++i) {
            String attribName = attributes.getLocalName(i);
            if (!attribName.equalsIgnoreCase(attributeName) || !attributes.getURI(i).equals(attributeNamespace)) continue;
            return attributes.getValue(i);
        }
        return defaultVal;
    }

    public static String getXPath(SAXElement element) {
        StringBuilder builder = new StringBuilder();
        SAXUtil.addXPathElement(element, builder);
        return builder.toString();
    }

    private static void addXPathElement(SAXElement element, StringBuilder builder) {
        if (builder.length() > 0) {
            builder.insert(0, "/");
            builder.insert(0, element.getName().getLocalPart());
        } else {
            builder.append(element.getName().getLocalPart());
        }
        SAXElement parent = element.getParent();
        if (parent != null) {
            SAXUtil.addXPathElement(parent, builder);
        }
    }

    public static int getDepth(SAXElement element) {
        int depth = 0;
        for (SAXElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    public static QName toQName(String namespaceURI, String localName, String qName) {
        if (namespaceURI != null) {
            int colonIndex;
            if (namespaceURI.length() != 0 && qName != null && (colonIndex = qName.indexOf(58)) != -1) {
                String prefix = qName.substring(0, colonIndex);
                String qNameLocalName = qName.substring(colonIndex + 1);
                return new QName(namespaceURI.intern(), qNameLocalName, prefix);
            }
            if (localName != null && localName.length() != 0) {
                return new QName(namespaceURI, localName);
            }
            if (qName != null && qName.length() != 0) {
                return new QName(namespaceURI, qName);
            }
            SAXUtil.thowInvalidNameException(namespaceURI, localName, qName);
        } else {
            if (localName != null && localName.length() != 0) {
                return new QName(localName);
            }
            SAXUtil.thowInvalidNameException(namespaceURI, localName, qName);
        }
        return null;
    }

    public static QName toQName(Element element) {
        if (element == null) {
            return null;
        }
        return SAXUtil.toQName(element.getNamespaceURI(), DomUtils.getName((Element)element), element.getNodeName());
    }

    static void thowInvalidNameException(String namespaceURI, String localName, String qName) {
        throw new IllegalArgumentException("Invalid QName: namespaceURI='" + namespaceURI + "', localName='" + localName + "', qName='" + qName + "'.");
    }
}

