/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.visitors.set;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Filter;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.sax.DefaultSAXElementSerializer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.util.FreeMarkerTemplate;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

public class SetElementData
extends DefaultSAXElementSerializer
implements DOMVisitAfter {
    protected static final String ATTRIBUTE_DATA = "attributeData";
    private String elementQName;
    private String elementName;
    private String elementNamespace;
    private String elementNamespacePrefix;
    private Map<QName, FreeMarkerTemplate> attributes = new LinkedHashMap<QName, FreeMarkerTemplate>();
    @Config
    private SmooksResourceConfiguration resourceConfig;

    @Initialize
    public void init() {
        List<Parameter> attributeDataParams;
        if (this.elementQName != null) {
            int nsPrefixIdx = this.elementQName.indexOf(":");
            if (nsPrefixIdx != -1) {
                this.elementNamespacePrefix = this.elementQName.substring(0, nsPrefixIdx);
                this.elementName = this.elementQName.substring(nsPrefixIdx + 1);
                if (this.elementNamespacePrefix.equals("xmlns") && this.elementNamespace == null) {
                    this.elementNamespace = "http://www.w3.org/2000/xmlns/";
                }
            } else {
                this.elementName = this.elementQName;
                if (this.elementName.equals("xmlns") && this.elementNamespace == null) {
                    this.elementNamespace = "http://www.w3.org/2000/xmlns/";
                }
            }
        }
        if ((attributeDataParams = this.resourceConfig.getParameters(ATTRIBUTE_DATA)) != null && !attributeDataParams.isEmpty()) {
            this.extractAttributeData(attributeDataParams);
        }
    }

    private void extractAttributeData(List<Parameter> attributeDataParams) {
        for (Parameter attributeDataParam : attributeDataParams) {
            QName qName;
            Element attributeElement = attributeDataParam.getXml();
            String name = attributeElement.getAttribute("name");
            String namespace = attributeElement.getAttribute("namespace");
            String value = attributeElement.getAttribute("value");
            int prefixTokIdx = name.indexOf(58);
            if (prefixTokIdx != -1) {
                String prefix = name.substring(0, prefixTokIdx);
                if (prefix.equals("xmlns") && namespace.equals("")) {
                    namespace = "http://www.w3.org/2000/xmlns/";
                }
                qName = new QName(namespace, name.substring(prefixTokIdx + 1), prefix);
            } else {
                if (name.equals("xmlns") && namespace.equals("")) {
                    namespace = "http://www.w3.org/2000/xmlns/";
                }
                qName = new QName(namespace, name);
            }
            this.attributes.put(qName, new FreeMarkerTemplate(value));
        }
    }

    @ConfigParam(name="name", use=ConfigParam.Use.OPTIONAL)
    public SetElementData setElementName(String elementQName) {
        this.elementQName = elementQName;
        return this;
    }

    @ConfigParam(name="namespace", use=ConfigParam.Use.OPTIONAL)
    public SetElementData setElementNamespace(String namespace) {
        this.elementNamespace = namespace;
        return this;
    }

    public SetElementData setAttribute(QName name, String valueTemplate) {
        this.attributes.put(name, new FreeMarkerTemplate(valueTemplate));
        return this;
    }

    @Override
    protected void writeStart(SAXElement element) throws IOException {
        SAXElement reconstructedElement = this.reconstructElement(element);
        super.writeStart(reconstructedElement);
        element.setCache(this, reconstructedElement.getCache(this));
    }

    @Override
    protected void writeEnd(SAXElement element) throws IOException {
        SAXElement reconstructedElement = this.reconstructElement(element);
        reconstructedElement.setCache(this, element.getCache(this));
        super.writeEnd(reconstructedElement);
    }

    private SAXElement reconstructElement(SAXElement element) {
        QName qName = element.getName();
        if (this.elementQName != null || this.elementNamespace != null) {
            String newElementName = this.elementName != null ? this.elementName : qName.getLocalPart();
            String newElementNamespace = this.elementNamespace != null ? this.elementNamespace : qName.getNamespaceURI();
            String newElementNamespacePrefix = this.elementNamespacePrefix != null ? this.elementNamespacePrefix : qName.getPrefix();
            qName = new QName(newElementNamespace, newElementName, newElementNamespacePrefix);
        }
        SAXElement newElement = new SAXElement(qName, element.getAttributes(), element.getParent());
        newElement.setWriter(element.getWriter(this), this);
        if (!this.attributes.isEmpty()) {
            Map<String, Object> beans = Filter.getCurrentExecutionContext().getBeanContext().getBeanMap();
            Set<Map.Entry<QName, FreeMarkerTemplate>> attributeSet = this.attributes.entrySet();
            for (Map.Entry<QName, FreeMarkerTemplate> attributeConfig : attributeSet) {
                QName attribName = attributeConfig.getKey();
                FreeMarkerTemplate valueTemplate = attributeConfig.getValue();
                String namespaceURI = attribName.getNamespaceURI();
                if (namespaceURI != null) {
                    String prefix = attribName.getPrefix();
                    if (prefix != null && prefix.length() > 0) {
                        newElement.setAttributeNS(namespaceURI, prefix + ":" + attribName.getLocalPart(), valueTemplate.apply(beans));
                        continue;
                    }
                    newElement.setAttributeNS(namespaceURI, attribName.getLocalPart(), valueTemplate.apply(beans));
                    continue;
                }
                newElement.setAttribute(attribName.getLocalPart(), valueTemplate.apply(beans));
            }
        }
        return newElement;
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.elementQName != null || this.elementNamespace != null) {
            String newElementName = this.elementQName != null ? this.elementQName : element.getTagName();
            String newElementNamespace = this.elementNamespace != null ? this.elementNamespace : element.getNamespaceURI();
            element = DomUtils.renameElementNS((Element)element, (String)newElementName, (String)newElementNamespace, (boolean)true, (boolean)true);
        }
        if (!this.attributes.isEmpty()) {
            Map<String, Object> beans = Filter.getCurrentExecutionContext().getBeanContext().getBeanMap();
            Set<Map.Entry<QName, FreeMarkerTemplate>> attributeSet = this.attributes.entrySet();
            for (Map.Entry<QName, FreeMarkerTemplate> attributeConfig : attributeSet) {
                QName attribName = attributeConfig.getKey();
                FreeMarkerTemplate valueTemplate = attributeConfig.getValue();
                String namespaceURI = attribName.getNamespaceURI();
                if (namespaceURI != null) {
                    String prefix = attribName.getPrefix();
                    if (prefix != null && prefix.length() > 0) {
                        element.setAttributeNS(namespaceURI, prefix + ":" + attribName.getLocalPart(), valueTemplate.apply(beans));
                        continue;
                    }
                    element.setAttributeNS(namespaceURI, attribName.getLocalPart(), valueTemplate.apply(beans));
                    continue;
                }
                element.setAttribute(attribName.getLocalPart(), valueTemplate.apply(beans));
            }
        }
    }
}

