/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.custommonkey.xmlunit.XMLUnit;
import org.milyn.Smooks;
import org.milyn.archive.Archive;
import org.milyn.archive.ArchiveClassLoader;
import org.milyn.assertion.AssertArgument;
import org.milyn.classpath.CascadingClassLoaderSet;
import org.milyn.ect.EdiConvertionTool;
import org.milyn.edisax.util.IllegalNameException;
import org.milyn.ejc.EJCExecutor;
import org.milyn.io.StreamUtils;
import org.milyn.payload.StringResult;
import org.milyn.payload.StringSource;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchange;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchangeFactory;
import org.milyn.test.ant.AntRunner;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.EclipseFragmentXMLValidator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EdifactDirTestHarness
implements UNEdifactInterchangeFactory {
    private String urn;
    private Archive mappingModel;
    private Archive bindingModel;
    private ArchiveClassLoader mappingModelClassLoader;
    private ArchiveClassLoader bindingModelClassLoader;
    private UNEdifactInterchangeFactory factory;

    public EdifactDirTestHarness(File edifactSpecFile, String ... messages) {
        AssertArgument.isNotNull((Object)edifactSpecFile, (String)"edifactSpecFile");
        if (!edifactSpecFile.exists()) {
            throw new IllegalArgumentException("Unable to locate EDI Spec file '" + edifactSpecFile.getAbsolutePath() + "'.");
        }
        if (!edifactSpecFile.isFile()) {
            throw new IllegalArgumentException("Specified EDI Spec file '" + edifactSpecFile.getAbsolutePath() + "' is not a file.");
        }
        String zipFileName = edifactSpecFile.getName();
        this.urn = "org.milyn.edi.unedifact:" + zipFileName.substring(0, zipFileName.indexOf(46)) + "-mapping:1.0";
        try {
            this.mappingModel = EdiConvertionTool.fromUnEdifactSpec((File)edifactSpecFile, (String)this.urn, (String[])messages);
            this.mappingModelClassLoader = new ArchiveClassLoader(this.mappingModel);
            this.bindingModel = this.buildBindingModel(this.urn, messages);
            this.bindingModelClassLoader = new ArchiveClassLoader((ClassLoader)this.mappingModelClassLoader, this.bindingModel);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading specification '" + edifactSpecFile.getAbsolutePath() + "'.", e);
        }
    }

    public String getUrn() {
        return this.urn;
    }

    public Archive getMappingModel() {
        return this.mappingModel;
    }

    public Archive getBindingModel() {
        return this.bindingModel;
    }

    public ArchiveClassLoader getMappingModelClassLoader() {
        return this.mappingModelClassLoader;
    }

    public ArchiveClassLoader getBindingModelClassLoader() {
        return this.bindingModelClassLoader;
    }

    public UNEdifactInterchange fromUNEdifact(InputStream ediStream, Result ... additionalResults) throws IOException {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.bindingModelClassLoader);
        try {
            UNEdifactInterchange uNEdifactInterchange = this.getFactory().fromUNEdifact(ediStream, additionalResults);
            return uNEdifactInterchange;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing EDIFACT stream for '" + this.urn + "'.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }

    public UNEdifactInterchange fromUNEdifact(InputSource ediSource, Result ... additionalResults) throws IOException {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.bindingModelClassLoader);
        try {
            UNEdifactInterchange uNEdifactInterchange = this.getFactory().fromUNEdifact(ediSource, additionalResults);
            return uNEdifactInterchange;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing EDIFACT stream for '" + this.urn + "'.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }

    public void toUNEdifact(UNEdifactInterchange interchange, Writer writer) throws IOException {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.bindingModelClassLoader);
        try {
            this.getFactory().toUNEdifact(interchange, writer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error writing EDIFACT stream for '" + this.urn + "'.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }

    public void setReportPath(String reportPath) {
        this.getFactory().setReportPath(reportPath);
    }

    public UNEdifactInterchangeFactory getFactory() {
        if (this.factory == null) {
            ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bindingModelClassLoader);
            try {
                this.factory = (UNEdifactInterchangeFactory)this.bindingModelClassLoader.loadClass("org.smooks.ejc.test.TESTInterchangeFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading Factory class for '" + this.urn + "'.", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origTCCL);
            }
        }
        return this.factory;
    }

    public void assertJavaReadWriteOK(InputStream edifactStream) throws IOException {
        this.assertJavaReadWriteOK(new InputStreamReader(edifactStream, "UTF-8"));
    }

    public void assertJavaReadWriteOK(Reader edifactStream) throws IOException {
        String inputMessage = StreamUtils.readStream((Reader)edifactStream);
        InputSource ediSource = new InputSource();
        ediSource.setByteStream(new ByteArrayInputStream(inputMessage.getBytes()));
        ediSource.setCharacterStream(new StringReader(inputMessage));
        UNEdifactInterchange interchange = this.fromUNEdifact(ediSource, new Result[0]);
        StringWriter writer = new StringWriter();
        interchange.write((Writer)writer);
        String normalizedInput = StreamUtils.normalizeLines((String)inputMessage, (boolean)true);
        String normalizedOutput = StreamUtils.normalizeLines((String)writer.toString(), (boolean)true);
        if (!normalizedOutput.equals(normalizedInput)) {
            throw new IllegalStateException("EDIFACT Java Object model read + write failed to produce an equivalent EDIFACT message.  Input EDIFACT message: \n\n\t" + inputMessage + "\n\n Serialized Java result was: \n\n\t" + writer.toString() + "\n");
        }
    }

    public void assertXMLOK(InputStream edifactIn, InputStream expectedXMLOut) throws IOException, SAXException {
        this.assertXMLOK(edifactIn, expectedXMLOut, true);
    }

    public void assertXMLOK(InputStream edifactIn, InputStream expectedXMLOut, boolean validate) throws IOException, SAXException {
        StringResult xmlResult = new StringResult();
        String expectedXML = StreamUtils.readStreamAsString((InputStream)expectedXMLOut);
        this.fromUNEdifact(edifactIn, new Result[]{xmlResult});
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.compareXML((String)expectedXML, (String)xmlResult.getResult());
        if (validate) {
            ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.bindingModelClassLoader);
            try {
                XMLSchemaFactory schemaFactory = new XMLSchemaFactory();
                try {
                    schemaFactory.setProperty("http://apache.org/xml/properties/security-manager", null);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                EclipseFragmentXMLValidator validator = new EclipseFragmentXMLValidator((SchemaFactory)schemaFactory);
                validator.validate((Source)new StringSource(xmlResult.getResult()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error processing EDIFACT stream for '" + this.urn + "'.", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origTCCL);
            }
        }
    }

    public void smooksFilterSource(String smooksConfig, Source source, Result ... results) {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        CascadingClassLoaderSet filteringClassLoader = new CascadingClassLoaderSet();
        filteringClassLoader.addClassLoader((ClassLoader)this.bindingModelClassLoader);
        filteringClassLoader.addClassLoader(origTCCL);
        Thread.currentThread().setContextClassLoader((ClassLoader)filteringClassLoader);
        try {
            Smooks smooks = new Smooks(smooksConfig);
            smooks.filterSource(source, results);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error filtering source stream using Smooks configuration file '" + smooksConfig + "' for EDIFACT URN '" + this.urn + "'.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Archive buildBindingModel(String urn, String[] messages) throws IOException, SAXException, IllegalNameException, ClassNotFoundException {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.mappingModelClassLoader);
        try {
            AntRunner antRunner = new AntRunner("build.xml", new String[0]);
            EJCExecutor ejc = new EJCExecutor();
            File destDir = new File("target/ejc/src");
            antRunner.run("delete");
            if (messages != null && messages.length != 0) {
                ejc.setMessages(CollectionsUtil.toSet((Object[])messages));
            }
            ejc.setDestDir(destDir);
            ejc.setEdiMappingModel("urn:" + urn);
            ejc.setPackageName("org.smooks.ejc.test");
            ejc.execute();
            antRunner.run("compile");
            Archive archive = new Archive(new ZipInputStream(new FileInputStream("./target/ejc/ejc.jar")));
            return archive;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }
}

